/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.omnibox;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.EnginesContextUtil;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.ActionEx;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ContentAssistedText2;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete2.AbstractCAProcessor;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete2.AbstractCL;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.edition.EditOmniboxFocusHandler;
import com.pnfsoftware.jeb.rcpclient.omnibox.CP;
import com.pnfsoftware.jeb.rcpclient.omnibox.UnitContentsCache;
import com.pnfsoftware.jeb.rcpclient.omnibox.WorkspaceProposalRecorder;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Omnifind
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(Omnifind.class);
    public static final int DEFAULT_MAX_RECORD_COUNT = 200;
    public static final int DEFAULT_SEARCH_TIME_OUT_MS = 300;
    private static final int wantedCharLength = 60;
    private RcpClientContext ctx;
    private ContentAssistedText2 box;
    private CAProcessor caProcessor;
    public int maxRecordCount = 200;
    public int searchTimeOutMs = 300;
    private boolean showingGenericText;
    private int x = 50;

    public Omnifind(Composite parent, int style, final RcpClientContext ctx) {
        super(parent, 0);
        this.ctx = ctx;
        this.setLayout((Layout)new FillLayout());
        this.box = new ContentAssistedText2(this, style, null, null, false);
        this.box.setPureSearch(true);
        final StyledText wtext = this.box.getWidget();
        this.bgmode(wtext);
        wtext.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (Omnifind.this.box.isShowingProposals()) {
                    return;
                }
                if (wtext.getText().isEmpty()) {
                    Omnifind.this.bgmode(wtext);
                } else {
                    wtext.setSelection(0, 0);
                    Omnifind.this.showingGenericText = false;
                }
            }

            public void focusGained(FocusEvent e) {
                if (Omnifind.this.box.isShowingProposals()) {
                    return;
                }
                if (Omnifind.this.showingGenericText) {
                    wtext.setText("");
                    wtext.setForeground(null);
                    wtext.setSelectionForeground(null);
                    Omnifind.this.showingGenericText = false;
                } else {
                    wtext.selectAll();
                }
            }
        });
        wtext.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                PartManager pman;
                if (Omnifind.this.box.isShowingProposals()) {
                    if (e.detail == 16) {
                        e.doit = false;
                    } else if (e.detail == 4) {
                        e.doit = false;
                    }
                    return;
                }
                if (e.detail == 2 && ctx != null && (pman = ctx.getPartManager()) != null) {
                    IMPart part = pman.getActivePart();
                    if (part == null) {
                        part = pman.getMostRecentlyFocused(pman.getAllParts());
                    }
                    if (part != null) {
                        pman.focus(part);
                    }
                }
            }
        });
        GC gc = new GC((Drawable)this.box);
        try {
            gc.setFont(this.box.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.x = (int)(60.0 * fm.getAverageCharacterWidth());
        }
        finally {
            gc.dispose();
        }
        this.caProcessor = new CAProcessor(true);
        ContentAssistant ca = this.box.getContentAssistant();
        ca.addContentAssistProcessor(this.caProcessor, "__dftl_partition_content_type");
        ca.addCompletionListener(new AbstractCL(){

            @Override
            public void applied(ICompletionProposal proposal) {
                if (proposal instanceof CP) {
                    CP p = (CP)proposal;
                    if (ctx != null) {
                        if (p.unit != null && !p.unit.isDisposed() && p.unit.isProcessed()) {
                            try {
                                String addr = p.determineUnitAddress();
                                AddressNavigator nav = new AddressNavigator(ctx, p.unit);
                                nav.navigate(Strings.safe(addr));
                            }
                            catch (Exception ex) {
                                if (Licensing.isDebugBuild()) {
                                    throw ex;
                                }
                                String details = "?";
                                try {
                                    details = Strings.ff("unit-path= %s", UnitUtil.buildFullyQualifiedUnitPath(p.unit));
                                }
                                catch (Exception exception) {}
                                RcpClientContext.getInstance().getErrorHandler().processThrowable(ex, false, false, false, details, null, null);
                            }
                        } else if (p.object instanceof JebBaseHandler) {
                            JebBaseHandler h = (JebBaseHandler)p.object;
                            h.execute();
                        }
                    }
                }
            }
        });
    }

    private void bgmode(StyledText wtext) {
        String text = "Omnibox ...";
        try {
            List<Integer> list = AllHandlers.getInstance().get(EditOmniboxFocusHandler.class).getExtraAccelerators();
            if (list != null && !list.isEmpty()) {
                int keycode = list.get(0);
                String acc = ActionEx.getAcceleratorAsString(keycode);
                text = Strings.ff("Omnibox (%s) ...", acc);
            }
        }
        catch (Exception exception) {}
        wtext.setText(text);
        wtext.setForeground(this.getDisplay().getSystemColor(15));
        wtext.setSelectionForeground(this.getDisplay().getSystemColor(15));
        this.showingGenericText = true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point pt = super.computeSize(wHint, hHint, changed);
        if (hHint == -1) {
            pt.x = this.x;
        }
        return pt;
    }

    public boolean isFocusControl() {
        return this.box.isFocusControl();
    }

    public IRuntimeProject getProject() {
        IEnginesContext engctx = JebCoreService.getDefaultEnginesContext();
        if (engctx == null) {
            return null;
        }
        return EnginesContextUtil.getMainProject(engctx);
    }

    public void clearCache() {
        if (this.caProcessor != null) {
            this.caProcessor.resetCaches();
        }
    }

    public void setMaxRecordCount(int maxRecordCount) {
        this.maxRecordCount = maxRecordCount;
        this.clearCache();
    }

    public int getMaxRecordCount() {
        return this.maxRecordCount;
    }

    public void setSearchTimeOutMs(int searchTimeOutMs) {
        this.searchTimeOutMs = searchTimeOutMs;
        this.clearCache();
    }

    public int getSearchTimeOutMs() {
        return this.searchTimeOutMs;
    }

    public void clearTextDocSearchCache() {
        if (this.caProcessor != null) {
            this.caProcessor.clearTextDocSearchCache();
        }
    }

    public void setTextDocSearchEnabled(boolean enabled) {
        if (this.caProcessor != null) {
            this.caProcessor.setTextDocSearchEnabled(enabled);
        }
    }

    public boolean isTextDocSearchEnabled() {
        return this.caProcessor != null && this.caProcessor.isTextDocSearchEnabled();
    }

    private class CAProcessor
    extends AbstractCAProcessor {
        private boolean enableProposalsCaching;
        private String input0;
        private ICompletionProposal[] results0;
        private UnitContentsCache unitTextDocContentsCache = null;

        CAProcessor(boolean enableProposalsCaching) {
            this.enableProposalsCaching = enableProposalsCaching;
        }

        public void resetCaches() {
            this.input0 = null;
            this.results0 = null;
            this.clearTextDocSearchCache();
        }

        @Override
        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            Object statusMessage;
            List<Object> r;
            String input = null;
            try {
                input = viewer.getDocument().get();
                if (this.enableProposalsCaching && this.input0 != null && this.input0.equals(input) && this.results0 != null) {
                    return this.results0;
                }
                this.input0 = null;
                this.results0 = null;
                (new Object[1])[0] = input;
                IRuntimeProject prj = Omnifind.this.getProject();
                WorkspaceProposalRecorder recorder = new WorkspaceProposalRecorder(input, Omnifind.this.maxRecordCount, prj, this.unitTextDocContentsCache, Omnifind.this.searchTimeOutMs);
                Object[] objectArray = new Object[]{Omnifind.this.maxRecordCount, Omnifind.this.searchTimeOutMs};
                long t0 = System.currentTimeMillis();
                boolean recordedAll = recorder.process();
                Object[] objectArray2 = new Object[]{System.currentTimeMillis() - t0, recordedAll};
                r = recorder.getRecords();
                int cnt = r.size();
                statusMessage = Strings.ff("%d %s", cnt, PluralFormatter.count(cnt, "entry", "entries"));
                if (!recordedAll) {
                    statusMessage = recorder.isTimedOut() ? (String)statusMessage + Strings.ff(" (timed-out %dms)", Omnifind.this.searchTimeOutMs) : (String)statusMessage + " (capped)";
                }
            }
            catch (Exception e) {
                RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(e);
                logger.error("An error occurred when retrieving the completion proposals", new Object[0]);
                logger.catchingSilent(e);
                r = new ArrayList();
                statusMessage = "An error occurred";
            }
            try {
                Omnifind.this.box.getContentAssistant().setStatusMessage((String)statusMessage);
            }
            catch (Exception exception) {}
            this.input0 = input;
            this.results0 = r.toArray(new ICompletionProposal[r.size()]);
            return this.results0;
        }

        public void clearTextDocSearchCache() {
            if (this.unitTextDocContentsCache != null) {
                this.unitTextDocContentsCache.clear();
            }
        }

        public boolean isTextDocSearchEnabled() {
            return this.unitTextDocContentsCache != null;
        }

        public void setTextDocSearchEnabled(boolean enabled) {
            if (enabled) {
                if (this.unitTextDocContentsCache == null) {
                    this.unitTextDocContentsCache = new UnitContentsCache();
                }
            } else if (this.unitTextDocContentsCache != null) {
                this.unitTextDocContentsCache.clear();
                this.unitTextDocContentsCache = null;
            }
        }
    }
}

