/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.omnibox;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.CodeUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete2.AbstractCP;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

class CP
extends AbstractCP
implements ICompletionProposalExtension6 {
    private static final ILogger logger = GlobalLog.getLogger(CP.class);
    EntryType entryType;
    Image image;
    String imagePath;
    Object object;
    IUnit unit;
    String unitAddress;
    String metainfo;
    private static StyledString.Styler metaStyler;

    public CP(EntryType entryType, String replacementString, String currentInput) {
        this(entryType, replacementString, 0, currentInput.length(), replacementString.length());
    }

    private CP(EntryType entryType, String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition);
        if (entryType == null) {
            throw new IllegalArgumentException();
        }
        this.entryType = entryType;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setUnit(IUnit unit) {
        this.unit = unit;
    }

    public void setUnitAddress(String unitAddress) {
        this.unitAddress = unitAddress;
    }

    public String determineUnitAddress() {
        if (this.unitAddress != null) {
            return this.unitAddress;
        }
        if (this.unit instanceof ICodeUnit && this.object instanceof ICodeItem) {
            return CodeUtil.findCodeItemReference((ICodeUnit)this.unit, (ICodeItem)this.object, 0);
        }
        return null;
    }

    public void setMetainfo(String metainfo) {
        this.metainfo = metainfo;
    }

    @Override
    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.imagePath == "") {
            return null;
        }
        if (this.imagePath != null) {
            return UIAssetManager.getInstance().getImage(this.imagePath);
        }
        if (this.unit != null) {
            return UnitPartManager.getIconForUnit(this.unit);
        }
        return null;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public StyledString getStyledDisplayString() {
        StyledString ss = new StyledString(this.getDisplayString());
        if (this.metainfo != null) {
            ss.append(" - " + this.metainfo, metaStyler);
        }
        if (this.unit != null) {
            ss.append(" - " + UnitUtil.buildFullyQualifiedUnitPath(this.unit), metaStyler);
        }
        return ss;
    }

    @Override
    public String getAdditionalProposalInfo() {
        JebBaseHandler h;
        StringBuilder sb = new StringBuilder("<!doctype html>");
        Strings.ff(sb, "<b>Entry</b>: %s<br>\n", CP.esc(this.entryType.toString()));
        if (this.unit != null) {
            if (!this.unit.isProcessed()) {
                sb.append("This unit has not been processed yet. Hit Enter to process it.<br>\n");
            } else {
                Strings.ff(sb, "<b>Unit</b>: %s<br>\n", UnitUtil.buildFullyQualifiedUnitPath(this.unit));
                if (!Strings.isBlank(this.unitAddress)) {
                    Strings.ff(sb, "<b>Address</b>: %s<br>\n", CP.esc(this.unitAddress));
                }
                if (this.entryType == EntryType.Unit) {
                    String notes;
                    String desc = this.unit.getDescription();
                    if (!Strings.isBlank(desc)) {
                        Strings.ff(sb, "<b>Description</b>: <pre>%s</pre><br>\n", CP.escPre(desc));
                    }
                    if (!Strings.isBlank(notes = this.unit.getNotes())) {
                        Strings.ff(sb, "<b>Notes</b>: <pre>%s</pre><br>\n", CP.escPre(notes));
                    }
                } else if (this.unitAddress != null) {
                }
            }
        }
        if (this.object instanceof JebBaseHandler && !Strings.isBlank((h = (JebBaseHandler)this.object).getDescription())) {
            Strings.ff(sb, "<b>Description</b>: %s<br>\n", CP.esc(h.getDescription()));
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    static String esc(String str) {
        return Formatter.htmlEscape(str, true);
    }

    static String escPre(String str) {
        return Formatter.htmlEscape(str, false);
    }

    static String tagesc(String str) {
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        return str;
    }

    static {
        JFaceResources.getColorRegistry().put("META_INFO", SwtRegistry.getInstance().getDisplay().getSystemColor(15).getRGB());
        metaStyler = StyledString.createColorRegistryStyler("META_INFO", null);
    }

    static enum EntryType {
        Other,
        Handler,
        Artifact,
        Unit,
        UnitTextDocument,
        Address,
        Comment,
        String,
        MetaString,
        Class,
        Field,
        Method;

    }
}

