/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.XmlBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeUtil {
    private static final TagNames xmlTags = new TagNames("<item>", "</item>", "<value>", "</value>"){

        @Override
        CharSequence generateMultiColumnProperty(CharSequence name, CharSequence value, Image img, int index, int depth) {
            StringBuilder stb = new StringBuilder();
            stb.append("<property name=\"").append(name).append("\" value=\"").append(value).append("\"/>");
            return stb;
        }
    };

    public static String buildXml(Tree tree, int indent) {
        SwtTreeFormatter formatter = new SwtTreeFormatter(tree);
        StringBuilder stb = new StringBuilder();
        TreeUtil.populateExport(stb, 0, indent, formatter, tree.getItems(), xmlTags);
        return stb.toString();
    }

    static <T> void populateExport(StringBuilder stb, int i, int indent, TreeFormatter<T> formatter, T[] items, TagNames tags) {
        for (T item : items) {
            StringBuilder props = new StringBuilder();
            boolean generated = TreeUtil.populateProperties(props, i + 1, indent, formatter, item, tags);
            T[] children = formatter.getChildren(item);
            if (!generated && (children == null || children.length == 0)) continue;
            Image img = generated ? formatter.getPropertyImage(item, 0) : null;
            stb.append(Strings.generate(" ", i * indent)).append(tags.generateItemStart(img)).append("\n");
            stb.append((CharSequence)props);
            if (children != null && children.length > 0) {
                TreeUtil.populateExport(stb, i + 1, indent, formatter, children, tags);
            }
            stb.append(Strings.generate(" ", i * indent)).append(tags.itemEnd).append("\n");
        }
    }

    private static <T> boolean populateProperties(StringBuilder stb, int i, int indent, TreeFormatter<T> formatter, T item, TagNames tags) {
        if (formatter.getPropertySize() == 0) {
            CharSequence value = XmlBuilder.escapeAll(formatter.getPropertyValue(item, 0));
            if (value.length() == 0) {
                return false;
            }
            stb.append(Strings.generate(" ", i * indent)).append(tags.singlePropertyStart).append(value).append(tags.singlePropertyEnd).append("\n");
        } else {
            for (int j = 0; j < formatter.getPropertySize(); ++j) {
                CharSequence value = XmlBuilder.escapeAll(formatter.getPropertyValue(item, j));
                if (value.length() == 0) continue;
                CharSequence name = XmlBuilder.escapeAll(formatter.getPropertyName(item, j));
                Image img = formatter.getPropertyImage(item, j);
                stb.append(Strings.generate(" ", i * indent)).append(tags.generateMultiColumnProperty(name, value, img, j, i)).append("\n");
            }
        }
        return true;
    }

    public static class SwtTreeFormatter
    implements TreeFormatter<TreeItem> {
        Tree tree;
        TreeColumn[] tcs;

        public SwtTreeFormatter(Tree tree) {
            this.tree = tree;
            this.tcs = tree.getColumns();
        }

        public TreeItem[] getChildren(TreeItem t) {
            return t.getItems();
        }

        @Override
        public int getPropertySize() {
            return this.tcs.length;
        }

        @Override
        public String getPropertyName(TreeItem item, int i) {
            return this.tcs[i].getText();
        }

        @Override
        public String getPropertyValue(TreeItem item, int i) {
            if (this.tcs.length == 0) {
                return item.getText();
            }
            return item.getText(i);
        }

        @Override
        public Image getPropertyImage(TreeItem item, int i) {
            if (this.tcs.length == 0) {
                return item.getImage();
            }
            return item.getImage(i);
        }
    }

    static abstract class TagNames {
        private String itemStart;
        private String itemEnd;
        private String singlePropertyStart;
        private String singlePropertyEnd;

        public TagNames(String itemStart, String itemEnd, String singlePropertyStart, String singlePropertyEnd) {
            this.itemStart = itemStart;
            this.itemEnd = itemEnd;
            this.singlePropertyStart = singlePropertyStart;
            this.singlePropertyEnd = singlePropertyEnd;
        }

        CharSequence generateItemStart(Image img) {
            return this.itemStart;
        }

        abstract CharSequence generateMultiColumnProperty(CharSequence var1, CharSequence var2, Image var3, int var4, int var5);
    }

    public static interface TreeFormatter<T> {
        public T[] getChildren(T var1);

        public int getPropertySize();

        public String getPropertyName(T var1, int var2);

        public String getPropertyValue(T var1, int var2);

        public Image getPropertyImage(T var1, int var2);
    }
}

