/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.InteractiveTreeViewer;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.viewers.ViewerCell;

class LabelProvider
extends DefaultStyledCellLabelProvider {
    private InteractiveTreeViewer viewer;

    public LabelProvider(InteractiveTreeViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void update(ViewerCell cell) {
        Style style;
        IStyleProvider styleAdapter;
        Object e = cell.getElement();
        if (e instanceof INode && cell.getColumnIndex() == 0 && (styleAdapter = this.viewer.getStyleAdapter()) != null && (style = this.viewer.getStyleAdapter().getStyle((INode)e)) != null) {
            cell.setForeground(style.getColor());
            cell.setBackground(style.getBackgroungColor());
        }
        super.update(cell);
    }

    @Override
    public String getStringAt(Object element, int index) {
        if (element instanceof INode) {
            return this.getStringAt((INode)element, index);
        }
        return null;
    }

    private String getStringAt(INode n, int index) {
        if (index >= 1) {
            int i = index - 1;
            String[] additionalLabels = n.getAdditionalLabels();
            if (additionalLabels != null && i < additionalLabels.length) {
                return Strings.replaceNewLines(additionalLabels[i], " / ");
            }
        } else if (index == 0) {
            return Strings.replaceNewLines(n.getLabel(), " / ");
        }
        return null;
    }

    @Override
    public int getColumns(Object row) {
        if (row instanceof INode) {
            String[] additionalLabels = ((INode)row).getAdditionalLabels();
            return super.getColumns(row) + (additionalLabels == null ? 0 : additionalLabels.length);
        }
        return super.getColumns(row);
    }
}

