/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.tree;

import com.pnfsoftware.jeb.core.output.AbstractHtmlFormatter;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.TreeUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.XmlBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;

public class HtmlSwtTreeFormatter
extends AbstractHtmlFormatter<String> {
    private Tree tree;

    public HtmlSwtTreeFormatter(Tree tree, String title, StringBuilder cssdata, boolean insertCopyright) {
        super(title, cssdata, insertCopyright);
        this.tree = tree;
    }

    public String generate(int indent) {
        TreeUtil.SwtTreeFormatter formatter = new TreeUtil.SwtTreeFormatter(this.tree);
        StringBuilder stb = new StringBuilder();
        if (formatter.getPropertySize() > 0) {
            stb.append("<table>\n");
            stb.append("<tr>\n");
            for (int j = 0; j < formatter.getPropertySize(); ++j) {
                CharSequence name = XmlBuilder.escapeAll(formatter.getPropertyName(null, j));
                stb.append("<th>").append(name).append("</th>\n");
            }
            stb.append("</tr>\n");
        }
        TreeUtil.populateExport(stb, 0, indent, formatter, this.tree.getItems(), formatter.getPropertySize() == 0 ? new SingleHtmlTagNames() : new MultiColumnHtmlTagNames());
        if (formatter.getPropertySize() > 0) {
            stb.append("</table>");
        }
        return this.generate(stb);
    }

    @Override
    private String generateCssDivStyle(Image img) {
        String id = UIAssetManager.toBase64(img);
        return super.generateCssDivStyle(id);
    }

    private String generateCssDivStylePadding() {
        return super.generateCssDivStyle("padding:5px 10px");
    }

    @Override
    protected CharSequence generateCssBlock(String id, String classname) {
        StringBuilder sb = new StringBuilder().append(".").append(classname).append(" {\n");
        if (id.equals("padding:5px 10px")) {
            sb.append("  ").append(id).append(";\n");
        } else {
            sb.append("  list-style-image: url(data:image/png;base64,").append(id).append(");\n");
        }
        sb.append("}\n");
        return sb;
    }

    public static String buildHtml(Tree tree, int indent, String title) {
        HtmlSwtTreeFormatter htmlFormatter = new HtmlSwtTreeFormatter(tree, title, new StringBuilder(), true);
        return htmlFormatter.generate(indent);
    }

    private class SingleHtmlTagNames
    extends TreeUtil.TagNames {
        public SingleHtmlTagNames() {
            super("<ul>", "</ul>", "<li>", "</li>");
        }

        @Override
        protected CharSequence generateItemStart(Image img) {
            if (img == null) {
                return super.generateItemStart(img);
            }
            return "<ul class='" + HtmlSwtTreeFormatter.this.generateCssDivStyle(img) + "'>";
        }

        @Override
        CharSequence generateMultiColumnProperty(CharSequence name, CharSequence value, Image img, int index, int depth) {
            StringBuilder stb = new StringBuilder();
            stb.append("<span style='margin:0 20px'>").append(value).append("</span>");
            return stb;
        }
    }

    private class MultiColumnHtmlTagNames
    extends TreeUtil.TagNames {
        public MultiColumnHtmlTagNames() {
            super("<tr>", "</tr>", "<td>", "</td>");
        }

        @Override
        CharSequence generateMultiColumnProperty(CharSequence name, CharSequence value, Image img, int index, int depth) {
            StringBuilder stb = new StringBuilder();
            if (index == 0) {
                stb.append("<td><ul style='margin:0;'");
                if (img != null) {
                    stb.append(" class='").append(HtmlSwtTreeFormatter.this.generateCssDivStyle(img)).append("'");
                }
                stb.append(">").append(Strings.generate("<ul>", depth - 1)).append("<li>");
            } else {
                stb.append("<td class='").append(HtmlSwtTreeFormatter.this.generateCssDivStylePadding()).append("'>");
            }
            stb.append(value);
            if (index == 0) {
                stb.append("</li>").append(Strings.generate("</ul>", depth - 1)).append("</ul>");
            }
            stb.append("</td>");
            return stb;
        }
    }
}

