/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text.wrapped;

import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.DocumentManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.UnwrappedBufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.wrapped.WrappedAnchor;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.wrapped.WrappedLine;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class WrappedText {
    private static final ILogger logger = GlobalLog.getLogger(WrappedText.class);
    private DocumentManager docManager;
    private StyledText text;
    private Composite parent;
    private Integer maxVisibleLineCount;
    private int columnAffinity = -1;
    private boolean navigationMovedCaret = false;
    private boolean blockDisableRedraw = false;

    public WrappedText(final DocumentManager docManager, final StyledText text, Composite parent) {
        this.docManager = docManager;
        this.text = text;
        this.parent = parent;
        text.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WrappedText.this.maxVisibleLineCount = null;
                int x = text.getSize().x;
                if (x > 0) {
                    GC gc = new GC((Drawable)text);
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        int cnt = (int)((double)x / fm.getAverageCharacterWidth());
                        docManager.setWrapCount(cnt);
                    }
                    finally {
                        gc.dispose();
                    }
                }
            }
        });
    }

    public DocumentManager getDocumentManager() {
        return this.docManager;
    }

    public StyledText getTextWidget() {
        return this.text;
    }

    public void setBlockDisableRedraw(boolean blockDisableRedraw) {
        this.blockDisableRedraw = blockDisableRedraw;
    }

    public boolean isBlockDisableRedraw() {
        return this.blockDisableRedraw;
    }

    int sanitizeOffset(int bufferOffset) {
        return this.sanitizeOffset(bufferOffset, true);
    }

    int sanitizeOffset(int bufferOffset, boolean includeEnd) {
        if (bufferOffset < 0) {
            bufferOffset = 0;
        } else {
            int len = this.text.getCharCount();
            if (len == 0) {
                bufferOffset = 0;
            } else if (bufferOffset >= len) {
                bufferOffset = includeEnd ? len : len - 1;
            }
        }
        return bufferOffset;
    }

    int sanitizeLine(int lineIndex) {
        if (lineIndex < 0) {
            lineIndex = 0;
        } else {
            int len = this.text.getLineCount();
            if (len == 0) {
                throw new IllegalStateException("StyledText");
            }
            if (lineIndex >= len) {
                lineIndex = len - 1;
            }
        }
        return lineIndex;
    }

    public int getCaretOffset() {
        return this.text.getCaretOffset();
    }

    public void setCaretOffset(int offset) {
        this.text.setCaretOffset(this.sanitizeOffset(offset));
    }

    public int getCaretLine() {
        return this.text.getLineAtOffset(this.text.getCaretOffset());
    }

    public int getLineCount() {
        return this.text.getLineCount();
    }

    public int getFullyVisibleLineCount() {
        if (this.text.getLineHeight() == 0) {
            return 0;
        }
        if (this.text.getClientArea().height <= this.parent.getClientArea().height) {
            return this.text.getClientArea().height / this.text.getLineHeight();
        }
        if (this.parent.getClientArea().height > 20) {
            return (this.parent.getClientArea().height - 20) / this.text.getLineHeight();
        }
        return 0;
    }

    public int getVisibleLineCount() {
        return this.getBottomIndex() - this.getTopIndex() + 1;
    }

    public String getLine(int lineIndex) {
        return this.text.getLine(lineIndex);
    }

    public int getCharCount() {
        return this.text.getCharCount();
    }

    public int getTopIndex() {
        return this.text.getTopIndex();
    }

    public int getBottomIndex() {
        return JFaceTextUtil.getBottomIndex(this.text);
    }

    public void setTopIndex(int lineIndex) {
        this.text.setTopIndex(this.sanitizeLine(lineIndex));
    }

    public int getHorizontalIndex() {
        return this.text.getHorizontalIndex();
    }

    public void setHorizontalIndex(int column) {
        this.text.setHorizontalIndex(column);
    }

    public void setTopIndex(WrappedAnchor anchor) {
        int lineIndex = 0;
        if (anchor != null) {
            lineIndex = anchor.getWrappedLineIndex();
        }
        this.setTopIndex(lineIndex);
    }

    public ICoordinates getCoordinates(int bufferOffset) {
        int wrappedLineIndex = this.text.getLineAtOffset(bufferOffset);
        int wrappedColumnOffset = bufferOffset - this.text.getOffsetAtLine(wrappedLineIndex);
        UnwrappedBufferPoint p = this.unwrap(new BufferPoint(wrappedColumnOffset, wrappedLineIndex));
        if (p == null) {
            return null;
        }
        int lineIndex = p.getLineIndex();
        int columnOffset = p.getColumnOffset();
        WrappedAnchor bestAnchor = this.getAnchorAtLine(lineIndex);
        if (bestAnchor == null) {
            return null;
        }
        int lineDelta = lineIndex - bestAnchor.getUnwrappedLineIndex();
        return new Coordinates(bestAnchor.getIdentifier(), lineDelta, columnOffset);
    }

    public ICoordinates getTopIndexCoordinates() {
        return this.getCoordinates(this.text.getOffsetAtLine(this.text.getTopIndex()));
    }

    public ICoordinates getTopIndexCoordinates(int lineDelta) {
        return this.getCoordinates(this.text.getOffsetAtLine(this.text.getTopIndex() + lineDelta));
    }

    public ICoordinates getCaretCoordinates() {
        return this.getCoordinates(this.text.getCaretOffset());
    }

    public void setCaretCoordinates(ICoordinates caret, boolean eol) {
        int caretUnwrappedOffset;
        if (caret != null && (caretUnwrappedOffset = this.getBufferOffset(caret, eol)) >= 0) {
            this.text.setCaretOffset(caretUnwrappedOffset);
            return;
        }
        this.text.setCaretOffset(this.getLastLineOffset());
    }

    public BufferPoint getCaretViewportPoint() {
        int deltaX = this.getHorizontalIndex();
        int deltaY = this.getTopIndex();
        int caretOffset = this.getCaretOffset();
        int caretLine = this.getLineAtOffset(caretOffset);
        int caretOffsetInLine = caretOffset - this.getOffsetAtLine(caretLine);
        return new BufferPoint(caretOffsetInLine - deltaX, caretLine - deltaY);
    }

    public WrappedLine getCurrentLine() {
        int offset = this.getCaretOffset();
        int lineIndex = this.getLineAtOffset(offset);
        String line = this.getLine(lineIndex);
        int offsetAtLine = this.getOffsetAtLine(lineIndex);
        return new WrappedLine(offset, lineIndex, line, offsetAtLine);
    }

    public int getLastLineOffset() {
        int len = this.text.getLineCount();
        if (len == 0) {
            throw new IllegalStateException("StyledText");
        }
        return this.text.getOffsetAtLine(len - 1);
    }

    public boolean hasSelection() {
        return this.text.getSelectionCount() > 0;
    }

    public void setSelection(int start, int end) {
        this.text.setSelection(start, end);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public SelectionData getSelectionData() {
        return new SelectionData();
    }

    public Point getSelectionRange() {
        return this.text.getSelectionRange();
    }

    public void setSelectionRange(ICoordinates startCoords, boolean eol, int selectionLength) {
        int selectionStartOffset = startCoords != null ? this.getBufferOffset(startCoords, eol) : this.getLastLineOffset();
        if (selectionStartOffset >= 0) {
            this.setNavigationMovedCaret(true);
            this.text.setSelectionRange(selectionStartOffset, selectionLength);
        }
    }

    public void resetSelection() {
        SelectionData sel = this.getSelectionData();
        this.text.setSelectionRange(sel.getSelectionLength() >= 0 ? sel.boundOffsets.y : sel.boundOffsets.x, 0);
    }

    public int getMaxVisibleLineCount() {
        if (this.maxVisibleLineCount == null) {
            this.maxVisibleLineCount = this.getFullyVisibleLineCount();
            if (this.maxVisibleLineCount == 0) {
                this.maxVisibleLineCount = 100;
            }
        }
        return this.maxVisibleLineCount;
    }

    public int getWrappedLineCount() {
        return this.docManager.getWrappedLineCount();
    }

    public ITextDocumentPart getCurrentPart() {
        return this.docManager.getCurrentPart();
    }

    public int getBufferOffset(ICoordinates coord, boolean eol) {
        ITextDocumentPart part = this.docManager.getCurrentPart();
        if (!TextPartUtil.isInsidePart(part, coord)) {
            return -1;
        }
        int index = TextPartUtil.coordinatesToLineIndex(part, coord);
        BufferPoint p = this.wrap(new UnwrappedBufferPoint(coord.getColumnOffset(), index, eol));
        if (p == null) {
            String message = Strings.f("Can not wrap on %s at %s at index %d:%d (%b)", this.docManager.getDocument(), part.getAnchors().get(0), coord.getColumnOffset(), index, eol);
            logger.catchingSilent(new RuntimeException(message));
            return -1;
        }
        return this.text.getOffsetAtLine(p.getLineIndex()) + p.getColumnOffset();
    }

    public WrappedAnchor wrap(IAnchor anchor) {
        if (anchor == null) {
            return null;
        }
        return new WrappedAnchor(this.docManager, anchor);
    }

    public long getAnchorFirst() {
        return this.docManager.getAnchorFirst();
    }

    public WrappedAnchor getFirstVisibleAnchor() {
        return this.wrap(TextPartUtil.getFirstAnchor(this.docManager.getCurrentPart()));
    }

    public boolean isAnchorFirst(IAnchor anchor) {
        return anchor.getIdentifier() == this.docManager.getAnchorFirst();
    }

    public boolean isAnchorFirstDisplayed() {
        WrappedAnchor anchor = this.getFirstVisibleAnchor();
        if (anchor == null) {
            return false;
        }
        return this.isAnchorFirst(anchor.unwrap());
    }

    public long getAnchorEnd() {
        return this.docManager.getAnchorEnd();
    }

    public WrappedAnchor getEndVisibleAnchor() {
        return this.wrap(TextPartUtil.getLastAnchor(this.docManager.getCurrentPart()));
    }

    public boolean isAnchorEnd(IAnchor anchor) {
        long anchorEnd = this.docManager.getAnchorEnd();
        List<? extends IAnchor> anchorsDisplayed = this.docManager.getCurrentPart().getAnchors();
        if (anchorsDisplayed.get(anchorsDisplayed.size() - 1).getIdentifier() == anchorEnd) {
            return anchorsDisplayed.get(anchorsDisplayed.size() - 2).getIdentifier() == anchor.getIdentifier();
        }
        if (anchorsDisplayed.contains(anchor)) {
            return false;
        }
        return this.docManager.getAnchorEnd() - 1L == anchor.getIdentifier();
    }

    public boolean isAnchorEndDisplayed() {
        ITextDocumentPart part = this.docManager.getCurrentPart();
        if (part == null) {
            return false;
        }
        int cnt = part.getAnchors().size();
        if (cnt == 0) {
            return false;
        }
        IAnchor a = part.getAnchors().get(cnt - 1);
        return a.getIdentifier() == this.docManager.getAnchorEnd();
    }

    public WrappedAnchor getAnchorAtBufferOffset(int offset) {
        int wrappedLineIndex = this.text.getLineAtOffset(offset);
        return this.getAnchorAtBufferLine(wrappedLineIndex);
    }

    public WrappedAnchor getAnchorAtBufferLine(int line) {
        int lineIndex = this.docManager.unwrapLine(line);
        if (lineIndex < 0) {
            return null;
        }
        return this.getAnchorAtLine(lineIndex);
    }

    public WrappedAnchor getAnchorAtLine(int lineIndex) {
        IAnchor anchor = TextPartUtil.getAnchorAtLine(this.docManager.getCurrentPart(), lineIndex);
        if (anchor == null) {
            return null;
        }
        return new WrappedAnchor(this.docManager, anchor);
    }

    public int getLineAtOffset(int offset) {
        offset = this.sanitizeOffset(offset);
        return this.text.getLineAtOffset(offset);
    }

    public int getOffsetAtLine(int lineIndex) {
        if (lineIndex < 0) {
            return 0;
        }
        if (lineIndex >= this.text.getLineCount()) {
            return this.text.getCharCount();
        }
        return this.text.getOffsetAtLine(lineIndex);
    }

    public int getOffsetAtTopLine() {
        return this.getOffsetAtLine(this.getTopIndex());
    }

    public int getLineLength(int lineIndex) {
        return this.text.getLine(lineIndex).length();
    }

    public UnwrappedBufferPoint unwrap(int offset) {
        offset = this.sanitizeOffset(offset);
        int wrappedLineIndex = this.getLineAtOffset(offset);
        int wrappedColumnOffset = offset - this.getOffsetAtLine(wrappedLineIndex);
        return this.unwrap(new BufferPoint(wrappedColumnOffset, wrappedLineIndex));
    }

    public UnwrappedBufferPoint unwrap(BufferPoint point) {
        return this.docManager.unwrap(point);
    }

    public BufferPoint wrap(UnwrappedBufferPoint point) {
        return this.docManager.wrap(point);
    }

    public void moveCaret(int delta, boolean selecting) {
        Point sel = this.text.getSelection();
        int currentOffset = sel.x;
        int initialLength = 0;
        int selectionLength = 0;
        if (selecting) {
            if (this.text.getSelectionCount() != 0) {
                initialLength = selectionLength = this.text.getCaretOffset() != sel.x ? sel.y - sel.x : sel.x - sel.y;
            }
            if (initialLength > 0) {
                currentOffset = sel.y;
            }
        }
        int currentLine = this.text.getLineAtOffset(currentOffset);
        int lineStartOffset = this.text.getOffsetAtLine(currentLine);
        int columnOffset = currentOffset - lineStartOffset;
        currentOffset = lineStartOffset;
        if (selecting) {
            selectionLength -= columnOffset;
        }
        while (delta != 0) {
            currentLine = this.text.getLineAtOffset(currentOffset);
            if (delta > 0) {
                if (currentLine + 1 >= this.text.getLineCount()) break;
                currentOffset = this.text.getOffsetAtLine(currentLine + 1);
                if (selecting) {
                    selectionLength += this.text.getLine(currentLine).length() + 1;
                }
                --delta;
                continue;
            }
            if (currentLine - 1 < 0) break;
            currentOffset = this.text.getOffsetAtLine(currentLine - 1);
            if (selecting) {
                selectionLength -= this.text.getLine(currentLine - 1).length() + 1;
            }
            ++delta;
        }
        if (columnOffset > this.text.getLine(currentLine = this.text.getLineAtOffset(currentOffset)).length()) {
            columnOffset = this.text.getLine(currentLine).length();
        }
        if (selecting) {
            this.text.setSelectionRange(initialLength >= 0 ? sel.x : sel.y, selectionLength + columnOffset);
        } else {
            this.setCaretWithColumnAffinity(currentOffset + columnOffset);
        }
    }

    public void forceSelectionOffset(int offset) {
        Point sel = this.text.getSelection();
        int selectionLength = 0;
        if (this.text.getSelectionCount() != 0) {
            int n = selectionLength = this.text.getCaretOffset() != sel.x ? sel.y - sel.x : sel.x - sel.y;
        }
        if (selectionLength > 0) {
            this.text.setSelectionRange(sel.x, offset - sel.x);
        } else {
            this.text.setSelectionRange(sel.y, offset - sel.y);
        }
    }

    public void setCaretWithColumnAffinity(int offset) {
        int line;
        int lineStartOffset;
        int currentColumnPosition;
        if (this.columnAffinity >= 0 && (currentColumnPosition = offset - (lineStartOffset = this.getOffsetAtLine(line = this.getLineAtOffset(offset)))) < this.columnAffinity) {
            offset = lineStartOffset + Math.min(this.columnAffinity, this.text.getLine(line).length());
        }
        this.setNavigationMovedCaret(true);
        this.setCaretOffset(offset);
    }

    public boolean isNavigationMovedCaret() {
        return this.navigationMovedCaret;
    }

    public void setNavigationMovedCaret(boolean moved) {
        this.navigationMovedCaret = moved;
    }

    public void updateColumnAffinityFromCaret() {
        int caretOffset = this.text.getCaretOffset();
        int caretLine = this.text.getLineAtOffset(caretOffset);
        int lineStartOffset = this.text.getOffsetAtLine(caretLine);
        this.columnAffinity = caretOffset - lineStartOffset;
    }

    public boolean updateCaretColumn() {
        if (this.isNavigationMovedCaret()) {
            this.setNavigationMovedCaret(false);
            return false;
        }
        this.updateColumnAffinityFromCaret();
        return true;
    }

    public boolean isCaretEol() {
        int caretLine;
        int caretOffset = this.text.getCaretOffset();
        if (this.text.getSelectionCount() != 0) {
            SelectionData sel = this.getSelectionData();
            caretOffset = sel.selectionLength >= 0 ? sel.boundOffsets.x : sel.boundOffsets.y;
        }
        return this.getLineLength(caretLine = this.text.getLineAtOffset(caretOffset)) == caretOffset - this.text.getOffsetAtLine(caretLine);
    }

    public boolean isCurrentPartLastLineDisplayed() {
        return this.getMaxVisibleLineCount() + this.text.getTopIndex() >= this.text.getLineCount();
    }

    public void setRedraw(boolean redraw) {
        if (this.blockDisableRedraw) {
            return;
        }
        this.text.setRedraw(redraw);
    }

    public void update() {
        this.text.update();
    }

    public class SelectionData {
        private Point boundOffsets;
        private int selectionLength;
        private ICoordinates selectionStartCoord;

        public SelectionData() {
            this.boundOffsets = WrappedText.this.text.getSelection();
            this.selectionLength = WrappedText.this.text.getCaretOffset() != this.boundOffsets.x ? this.boundOffsets.y - this.boundOffsets.x : this.boundOffsets.x - this.boundOffsets.y;
            this.selectionStartCoord = WrappedText.this.getCoordinates(this.selectionLength > 0 ? this.boundOffsets.x : this.boundOffsets.y);
        }

        public int getSelectionLength() {
            return this.selectionLength;
        }

        public ICoordinates getSelectionStartCoord() {
            return this.selectionStartCoord;
        }

        public int getStartLine() {
            return WrappedText.this.text.getLineAtOffset(this.boundOffsets.x);
        }

        public int getEndLine() {
            return WrappedText.this.text.getLineAtOffset(this.boundOffsets.y);
        }
    }
}

