/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IMetadataManager;

public class NavBarProperties {
    public static final int defaultThickness = 18;
    private ITextDocument doc;
    private IMetadataManager mm;
    private int position;
    private int thickness;

    public static NavBarProperties create(ITextDocument doc, IMetadataManager mm, int position, int thickness) {
        switch (position) {
            case 1: {
                position = 128;
                break;
            }
            case 2: {
                position = 131072;
                break;
            }
            case 3: {
                position = 1024;
                break;
            }
            case 4: {
                position = 16384;
                break;
            }
            default: {
                return null;
            }
        }
        if (thickness == 0) {
            return null;
        }
        if (thickness < 0) {
            thickness = 18;
        }
        return new NavBarProperties(doc, mm, position, thickness);
    }

    private NavBarProperties(ITextDocument doc, IMetadataManager mm, int position, int thickness) {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        if (position != 128 && position != 1024 && position != 16384 && position != 131072) {
            throw new IllegalArgumentException();
        }
        if (thickness < 0) {
            throw new IllegalArgumentException();
        }
        this.doc = doc;
        this.mm = mm;
        this.position = position;
        this.thickness = thickness;
    }

    public ITextDocument getDocument() {
        return this.doc;
    }

    public IMetadataManager getMetadataManager() {
        return this.mm;
    }

    public int getPosition() {
        return this.position;
    }

    public int getThickness() {
        return this.thickness;
    }
}

