/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IMetadataGroup;
import com.pnfsoftware.jeb.core.units.IMetadataManager;
import com.pnfsoftware.jeb.core.units.MetadataGroupType;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.MetadataColorProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.UnwrappedBufferPoint;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolTip;

public class NavBar
extends Canvas {
    private static final ILogger logger = GlobalLog.getLogger(NavBar.class);
    private boolean viewportBar;
    private InteractiveTextViewer textViewer;
    private ITextDocument idoc;
    private IMetadataManager metadataManager;
    private boolean vertical;
    private int lastKnownBarSize;
    private List<int[]> arrays = new ArrayList<int[]>();
    private boolean mouseButtonDown;
    private int mousePosition;
    private boolean moving;
    private ToolTip tip;
    private boolean zoomLevelChanged;
    private int barZoomLevel;
    private long barAnchorFirst;
    private long barAnchorEnd;
    private static final int caretWidth = 7;
    private static final int caretHalfSize = 5;
    private static final Color colorZoomRange = UIAssetManager.getInstance().getColor(255, 0, 0);
    private static final Color colorPartRange = UIAssetManager.getInstance().getColor(255, 153, 0);
    private static final Color colorIndicator = UIAssetManager.getInstance().getColor(255, 255, 0);
    private static final Color colorViewport = UIAssetManager.getInstance().getColor(102, 255, 0);
    private static final int rgbSectionLine = 3047494;
    private boolean ignoreNextNegativeValue;
    private boolean overflowDone;

    public NavBar(Composite parent, int styles, ITextDocument idoc, IMetadataManager metadataManager, final boolean viewportBar) {
        super(parent, 0x40000 | styles & 0x800);
        if (idoc == null) {
            throw new IllegalArgumentException();
        }
        this.idoc = idoc;
        this.metadataManager = metadataManager;
        this.viewportBar = viewportBar;
        boolean bl = this.vertical = (styles & 0x200) != 0;
        if (viewportBar && !this.vertical) {
            throw new IllegalArgumentException("The viewport bar must be a vertical bar");
        }
        this.barZoomLevel = 0;
        this.barAnchorFirst = idoc.getFirstAnchor();
        this.barAnchorEnd = idoc.getFirstAnchor() + idoc.getAnchorCount();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                NavBar.this.onPaintControl(e);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                NavBar.this.onMouseHover(e);
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                NavBar.this.onMouseUp(e);
            }

            public void mouseDown(MouseEvent e) {
                NavBar.this.onMouseDown(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                NavBar.this.onMouseMove(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                NavBar.this.onMouseWheelEvent(e);
            }
        });
        new ContextMenu((Control)this).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (viewportBar) {
                    return;
                }
                menuMgr.add(new ActionZoom(1));
                if (NavBar.this.barZoomLevel >= 1) {
                    menuMgr.add(new ActionZoom(-1));
                    menuMgr.add(new ActionZoom(0));
                }
            }
        });
    }

    void connectToViewer(InteractiveTextViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this.textViewer = viewer;
        this.textViewer.addCaretListener(e -> this.redraw());
        this.textViewer.addMouseWheelListener(e -> this.redraw());
    }

    public void refresh() {
        this.lastKnownBarSize = -1;
        this.redraw();
    }

    private long getBarAnchorRange() {
        return this.barAnchorEnd - this.barAnchorFirst;
    }

    private int getBarSize(Rectangle client) {
        return this.vertical ? client.height : client.width;
    }

    private int getBarWidth(Rectangle client) {
        return this.vertical ? client.width : client.height;
    }

    private void onPaintControl(PaintEvent e) {
        if (this.textViewer == null) {
            return;
        }
        Rectangle client = this.getClientArea();
        int size = this.getBarSize(client);
        int width = this.getBarWidth(client);
        if (!this.moving && (this.lastKnownBarSize != size || this.zoomLevelChanged || this.viewportBar)) {
            this.lastKnownBarSize = size;
            this.zoomLevelChanged = false;
            this.buildBars(size);
        }
        this.drawBars(e.gc);
        if (!this.viewportBar) {
            this.drawViewport(e.gc, size, width);
            this.drawCaretTriangle(e.gc, size);
        }
    }

    private void drawCaretTriangle(GC gc, int size) {
        int pos = this.getCaretTrianglePosition(size);
        if (pos >= 0 && pos < size) {
            gc.setBackground(colorIndicator);
            if (!this.vertical) {
                gc.fillPolygon(new int[]{pos - 5, 0, pos + 5, 0, pos, 7});
            } else {
                gc.fillPolygon(new int[]{0, pos - 5, 0, pos + 5, 7, pos});
            }
        }
    }

    private int getCaretTrianglePosition(int size) {
        ICoordinates coord = this.textViewer.getCaretCoordinates();
        int pos = coord != null ? this.coordToPixel(coord, size) : size - 1;
        return pos;
    }

    private void drawViewport(GC gc, int size, int width) {
        ICoordinates coord = this.textViewer.getWrappedText().getTopIndexCoordinates();
        if (coord != null) {
            int pos = this.coordToPixel(coord, size);
            int endPos = this.getViewportPositionEnd(size);
            if (pos < 0 && endPos >= 0) {
                pos = 0;
            }
            if (pos < size && endPos >= size) {
                endPos = size - 1;
            }
            if (pos >= 0 && pos < size) {
                boolean displayZone = endPos > pos + 2;
                gc.setForeground(colorViewport);
                gc.setBackground(colorViewport);
                int shift = this.barZoomLevel != 0 ? 4 : 2;
                NavBar.drawBar(gc, shift, pos, displayZone ? (long)endPos : (long)(pos + 2), this.vertical, width - 1 - shift, displayZone ? 40 : 255);
            }
        }
    }

    private int getViewportPositionEnd(int size) {
        int bufferOffset = this.textViewer.getWrappedText().getOffsetAtLine(this.textViewer.getWrappedText().getTopIndex() + this.textViewer.getWrappedText().getMaxVisibleLineCount());
        ICoordinates endCoord = this.textViewer.getWrappedText().getCoordinates(bufferOffset);
        int endPos = endCoord == null ? size : this.coordToPixel(endCoord, size);
        return endPos;
    }

    private void buildBars(int size) {
        this.arrays.clear();
        if (this.metadataManager != null) {
            for (IMetadataGroup iMetadataGroup : this.metadataManager.getGroups()) {
                List<String> sections;
                int i = -2;
                int[] array = new int[size * 2 + 1];
                MetadataGroupType grpType = iMetadataGroup.getType();
                MetadataColorProvider colorprv = new MetadataColorProvider(grpType, this.textViewer == null ? null : this.textViewer.styleAdapter, false);
                HashMap<String, Object> dataPerAddress = new HashMap<String, Object>();
                for (int pos = 0; pos < size; ++pos) {
                    ICoordinates coords = this.pixelToCoord(pos, size);
                    Object o = null;
                    if (coords != null) {
                        AddressConversionPrecision precision = AddressConversionPrecision.COARSE;
                        String address = this.idoc.coordinatesToAddress(coords, precision);
                        if (address == null) {
                            address = this.idoc.coordinatesToAddress(coords);
                            precision = AddressConversionPrecision.DEFAULT;
                        }
                        if ((o = (Object)dataPerAddress.get(address)) == null) {
                            o = iMetadataGroup.getData(address, precision);
                            dataPerAddress.put(address, o);
                        }
                    }
                    int rgb = colorprv.determineColor(o);
                    if (i < 0 || array[i + 1] != rgb) {
                        array[i += 2] = 1;
                        array[i + 1] = rgb;
                        continue;
                    }
                    int n = i;
                    array[n] = array[n] + 1;
                }
                array[i + 2] = -1;
                if (i != 0 || array[1] != colorprv.determineColor(null)) {
                    this.arrays.add(array);
                }
                if (this.viewportBar || (sections = iMetadataGroup.getSectionAnchorIds()) == null) continue;
                i = -2;
                array = new int[sections.size() * 4 + 3];
                int lastPixel = -2;
                for (String address : sections) {
                    int pixel;
                    ICoordinates c = this.textViewer.getDocument().addressToCoordinates(address);
                    if (c == null || lastPixel == (pixel = this.coordToPixel(c))) continue;
                    if (lastPixel + 1 == pixel) {
                        int n = i;
                        array[n] = array[n] + 1;
                    } else {
                        if (pixel != 0) {
                            array[i += 2] = lastPixel == -2 ? 0 : pixel - lastPixel - 1;
                            array[i + 1] = colorprv.determineColor(null);
                        }
                        array[i += 2] = 1;
                        array[i + 1] = 3047494;
                    }
                    lastPixel = pixel;
                }
                if (lastPixel < size) {
                    array[i += 2] = lastPixel == -2 ? 0 : size - lastPixel - 1;
                    array[i + 1] = colorprv.determineColor(null);
                }
                array[i + 2] = -1;
                if (i == 0 && array[1] == colorprv.determineColor(null)) continue;
                this.arrays.add(array);
            }
        }
        if (this.arrays.isEmpty()) {
            int i = -2;
            int[] nArray = new int[size * 2 + 1];
            int rgb = 0xD0D0D0;
            for (int pos = 0; pos < size; ++pos) {
                if (i < 0 || nArray[i + 1] != rgb) {
                    nArray[i += 2] = 1;
                    nArray[i + 1] = rgb;
                    continue;
                }
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            nArray[i + 2] = -1;
            this.arrays.add(nArray);
        }
    }

    private void drawBars(GC gc) {
        Rectangle ca = this.getClientArea();
        int fillsize = this.getBarWidth(ca);
        int maxSize = this.getBarSize(ca);
        int x2 = 0;
        for (int[] array : this.arrays) {
            int n;
            int x1 = x2;
            x2 = x1 + fillsize / this.arrays.size();
            int y = 0;
            int i = 0;
            while ((n = array[i]) >= 0) {
                if (array[i + 1] == -1) {
                    y += n;
                    i += 2;
                    continue;
                }
                Color c = UIAssetManager.getInstance().getColor(array[i + 1]);
                gc.setForeground(c);
                if (n == 1) {
                    this.drawLine(gc, x1, x2, y);
                    ++y;
                } else {
                    gc.setBackground(c);
                    if (this.vertical) {
                        gc.fillRectangle(x1, y, x2 - x1, n);
                    } else {
                        gc.fillRectangle(y, x1, n, x2 - x1);
                    }
                    y += n;
                }
                i += 2;
            }
        }
        if (!this.viewportBar) {
            if (this.getBarAnchorRange() > 1L) {
                this.drawPartRange(gc, maxSize);
            }
            this.drawZoomRange(gc, maxSize);
        }
    }

    private void drawPartRange(GC gc, int size) {
        ITextDocumentPart part = this.textViewer.getCurrentDocumentPart();
        if (part != null) {
            long partAnchor0 = TextPartUtil.getFirstAnchorId(part);
            long partAnchor1 = TextPartUtil.getNextAnchorId(part);
            gc.setBackground(colorPartRange);
            int pos0 = this.coordToPixel(new Coordinates(partAnchor0), size);
            int pos1 = this.coordToPixel(new Coordinates(partAnchor1), size);
            if (pos1 == -1) {
                pos1 = size;
            }
            if (pos0 < 0 && pos1 < 0) {
                return;
            }
            if (pos0 < 0) {
                pos0 = 0;
            }
            this.drawBar(gc, this.barZoomLevel != 0 ? 2 : 0, pos0, pos1);
        }
    }

    private void drawZoomRange(GC gc, int size) {
        if (this.barZoomLevel != 0) {
            gc.setBackground(colorZoomRange);
            long x0 = (this.barAnchorFirst - this.idoc.getFirstAnchor()) * (long)size / this.idoc.getAnchorCount();
            long x1 = (this.barAnchorEnd - this.idoc.getFirstAnchor()) * (long)size / this.idoc.getAnchorCount();
            this.drawBar(gc, 0, x0, x1);
        }
    }

    private void drawBar(GC gc, int index, long x0, long x1) {
        NavBar.drawBar(gc, index, x0, x1, this.vertical, 2, 255);
    }

    private static void drawBar(GC gc, int index, long x0, long x1, boolean vertical, int thickness, int alpha) {
        if (alpha != 255) {
            gc.setAlpha(alpha);
        }
        if (vertical) {
            gc.fillRectangle(index, (int)x0, thickness, (int)(x1 - x0));
            if (alpha != 255) {
                gc.setAlpha(255);
                gc.drawRectangle(index, (int)x0, thickness, (int)(x1 - x0));
            }
        } else {
            gc.fillRectangle((int)x0, index, (int)(x1 - x0), thickness);
            if (alpha != 255) {
                gc.setAlpha(255);
                gc.drawRectangle((int)x0, index, (int)(x1 - x0), thickness);
            }
        }
    }

    private void drawLine(GC gc, int x1, int x2, int pos) {
        if (this.vertical) {
            gc.drawLine(x1, pos, x2, pos);
        } else {
            gc.drawLine(pos, x1, pos, x2);
        }
    }

    private void onMouseHover(MouseEvent e) {
        if (this.viewportBar) {
            return;
        }
        this.disposeTooltip();
        ICoordinates coord = this.pixelToCoord(this.getMousePixelPosition(e));
        if (coord == null) {
            return;
        }
        String address = this.idoc.coordinatesToAddress(coord, AddressConversionPrecision.FINE);
        this.tip = new ToolTip(this.getShell(), 0);
        Point p = Display.getCurrent().getCursorLocation();
        Point widgetPosition = this.toDisplay(0, 0);
        Point size = this.getSize();
        if (MathUtil.betweenInclusive(p.x, widgetPosition.x, widgetPosition.x + size.x) && MathUtil.betweenInclusive(p.y, widgetPosition.y, widgetPosition.y + size.y)) {
            p.x += 5;
            p.y += 5;
            this.tip.setLocation(p);
            this.tip.setText("Use the mouse wheel to zoom in and out");
            this.tip.setMessage(Strings.safe(address));
            this.tip.setAutoHide(true);
            this.tip.setVisible(true);
        }
    }

    private void onMouseExit(MouseEvent e) {
    }

    private void onMouseEnter(MouseEvent e) {
    }

    private void disposeTooltip() {
        if (this.tip != null) {
            this.tip.setVisible(false);
            this.tip.dispose();
            this.tip = null;
        }
    }

    private ICoordinates pixelToCoord(int pixel) {
        return this.pixelToCoord(pixel, -1);
    }

    private boolean isMovingBottomEOF(int pixel) {
        int pixelMax;
        int n = pixelMax = this.vertical ? this.getClientArea().height : this.getClientArea().width;
        return this.textViewer.getWrappedText().isAnchorEndDisplayed() && this.textViewer.getWrappedText().isCurrentPartLastLineDisplayed() && pixel > pixelMax;
    }

    private ICoordinates pixelToCoord(int pixel, int pixelMax) {
        if (pixelMax < 0) {
            int n = pixelMax = this.vertical ? this.getClientArea().height : this.getClientArea().width;
        }
        if (this.viewportBar) {
            StyledText w = this.textViewer.getTextWidget();
            int y = pixel;
            int delta = w.getLineIndex(y) - w.getTopIndex();
            ICoordinates coord = this.textViewer.getWrappedText().getTopIndexCoordinates(delta);
            return coord;
        }
        long barAnchorRange = this.barAnchorEnd - this.barAnchorFirst;
        if (barAnchorRange == 1L) {
            ITextDocumentPart part = this.textViewer.getCurrentDocumentPart();
            List<? extends ILine> lines = TextPartUtil.getLinesOfAnchor(part, this.barAnchorFirst);
            if (lines != null) {
                return new Coordinates(this.barAnchorFirst, pixel * lines.size() / pixelMax);
            }
            return new Coordinates(this.barAnchorFirst);
        }
        return new Coordinates(this.barAnchorFirst + (long)((double)pixel * ((double)barAnchorRange / (double)pixelMax)));
    }

    private int coordToPixel(ICoordinates coord) {
        return this.coordToPixel(coord, this.vertical ? this.getClientArea().height : this.getClientArea().width);
    }

    private int coordToPixel(ICoordinates coord, int pixelMax) {
        if (this.viewportBar) {
            StyledText w = this.textViewer.getTextWidget();
            ITextDocumentPart part = this.textViewer.getCurrentDocumentPart();
            int index = TextPartUtil.coordinatesToLineIndex(part, coord);
            UnwrappedBufferPoint pt = new UnwrappedBufferPoint(0, index, false);
            BufferPoint ptWrapped = this.textViewer.getWrappedText().wrap(pt);
            if (ptWrapped == null) {
                return -1;
            }
            index = ptWrapped.lineIndex;
            int delta = index - w.getTopIndex();
            int pixel = w.getLinePixel(delta);
            return pixel;
        }
        long barAnchorRange = this.barAnchorEnd - this.barAnchorFirst;
        if (barAnchorRange == 1L) {
            if (coord.getAnchorId() == this.barAnchorFirst) {
                int lineDelta = coord.getLineDelta();
                ITextDocumentPart part = this.textViewer.getCurrentDocumentPart();
                List<? extends ILine> lines = TextPartUtil.getLinesOfAnchor(part, this.barAnchorFirst);
                if (lines != null && lineDelta >= 0 && lineDelta < lines.size()) {
                    return lineDelta * pixelMax / lines.size();
                }
            }
            return -1;
        }
        double r = (double)(coord.getAnchorId() - this.barAnchorFirst) / (double)barAnchorRange;
        return (int)((double)pixelMax * r);
    }

    private void onMouseDown(MouseEvent e) {
        if (this.viewportBar) {
            return;
        }
        this.mousePosition = this.getMousePixelPosition(e);
        if (e.button != 1) {
            return;
        }
        this.mouseButtonDown = true;
        this.setPosition(this.getMousePixelPosition(e));
    }

    private void onMouseUp(MouseEvent e) {
        if (this.viewportBar) {
            return;
        }
        this.mouseButtonDown = false;
        this.moving = false;
    }

    private void onMouseMove(MouseEvent e) {
        if (this.viewportBar) {
            return;
        }
        if (this.mouseButtonDown) {
            int pixelMax;
            this.moving = true;
            int pixel = this.getMousePixelPosition(e);
            int n = pixelMax = this.vertical ? this.getClientArea().height : this.getClientArea().width;
            if (pixel > pixelMax) {
                if (this.overflowDone) {
                    this.ignoreNextNegativeValue = false;
                } else {
                    this.ignoreNextNegativeValue = true;
                    this.overflowDone = true;
                }
            } else {
                this.overflowDone = false;
                if (pixel < 0 && this.ignoreNextNegativeValue) {
                    this.ignoreNextNegativeValue = false;
                    return;
                }
                this.ignoreNextNegativeValue = false;
            }
            if (this.isMovingBottomEOF(pixel)) {
                return;
            }
            this.setPosition(pixel);
        }
        this.disposeTooltip();
    }

    private void onMouseWheelEvent(MouseEvent e) {
        if (this.viewportBar) {
            return;
        }
        ICoordinates coord = this.pixelToCoord(this.getMousePixelPosition(e));
        if (coord == null) {
            return;
        }
        this.applyZoom(e.count, coord.getAnchorId());
    }

    private int getMousePixelPosition(MouseEvent e) {
        return this.vertical ? e.y : e.x;
    }

    private synchronized void setPosition(int pixel) {
        if (this.textViewer == null) {
            return;
        }
        ICoordinates coord = this.pixelToCoord(pixel);
        if (coord == null) {
            return;
        }
        ICoordinates carCoords = this.textViewer.getCaretCoordinates();
        if (coord.getAnchorId() >= this.barAnchorEnd) {
            this.textViewer.bufferManager.viewAtEndOfDocument();
        } else if (carCoords != null && (coord.getLineDelta() == 0 || coord.getAnchorId() == this.barAnchorFirst && coord.getLineDelta() < 0 || coord.getAnchorId() < this.barAnchorFirst)) {
            if (coord.getAnchorId() <= this.barAnchorFirst) {
                if (carCoords.getAnchorId() != this.barAnchorFirst || carCoords.getLineDelta() != 0) {
                    this.textViewer.bufferManager.viewAtStartOfDocument();
                }
            } else {
                this.textViewer.bufferManager.viewAtAnchor(coord.getAnchorId());
            }
        } else {
            BufferPoint point = this.textViewer.getCaretViewportPoint();
            if (this.textViewer.bufferManager.getWrappedText().isCurrentPartLastLineDisplayed()) {
                point = null;
            }
            this.textViewer.setCaretCoordinates(coord, point, false);
        }
        this.redraw();
    }

    private void applyZoom(int delta, long anchorPivot) {
        long newRange;
        long _barAnchorFirst = this.barAnchorFirst;
        long _barAnchorEnd = this.barAnchorEnd;
        int _barZoomLevel = this.barZoomLevel;
        long range = _barAnchorEnd - _barAnchorFirst;
        if (delta > 0) {
            ++_barZoomLevel;
            newRange = range / 2L;
        } else if (_barZoomLevel > 0) {
            if (delta == 0) {
                _barZoomLevel = 0;
                newRange = -1L;
            } else {
                --_barZoomLevel;
                newRange = range * 2L;
            }
        } else {
            return;
        }
        if (_barZoomLevel == 0) {
            _barAnchorFirst = this.idoc.getFirstAnchor();
            _barAnchorEnd = this.idoc.getFirstAnchor() + this.idoc.getAnchorCount();
        } else {
            long halfRange = newRange / 2L;
            _barAnchorFirst = anchorPivot - halfRange;
            if (_barAnchorFirst < this.idoc.getFirstAnchor()) {
                _barAnchorFirst = this.idoc.getFirstAnchor();
                _barAnchorEnd = _barAnchorFirst + newRange;
            } else {
                _barAnchorEnd = anchorPivot + halfRange;
                if (_barAnchorEnd >= this.idoc.getFirstAnchor() + this.idoc.getAnchorCount()) {
                    _barAnchorEnd = this.idoc.getFirstAnchor() + this.idoc.getAnchorCount();
                    _barAnchorFirst = _barAnchorEnd - newRange;
                }
            }
        }
        if (_barAnchorEnd <= _barAnchorFirst) {
            return;
        }
        this.barZoomLevel = _barZoomLevel;
        this.barAnchorFirst = _barAnchorFirst;
        this.barAnchorEnd = _barAnchorEnd;
        this.zoomLevelChanged = true;
        Object[] objectArray = new Object[]{this.barAnchorFirst, this.barAnchorEnd};
        this.redraw();
    }

    private class ActionZoom
    extends Action {
        int delta;

        public ActionZoom(int delta) {
            boolean enabled;
            String text;
            if (delta == 1) {
                text = "Zoom In";
                enabled = true;
            } else if (delta == -1) {
                text = "Zoom Out";
                enabled = NavBar.this.barZoomLevel >= 1;
            } else if (delta == 0) {
                text = "Reset Zoom";
                enabled = NavBar.this.barZoomLevel >= 1;
            } else {
                throw new IllegalArgumentException();
            }
            this.setText(text);
            this.setEnabled(enabled);
            this.delta = delta;
        }

        @Override
        public void run() {
            ICoordinates coord = NavBar.this.pixelToCoord(NavBar.this.mousePosition);
            NavBar.this.applyZoom(this.delta, coord.getAnchorId());
        }
    }
}

