/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.units.MetadataGroupType;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class MetadataColorProvider {
    public static final int emptyColor = 0xD0D0D0;
    public static final int defaultColor = 0x606060;
    private MetadataGroupType grpType;
    private IStyleProvider stylePrv;
    private boolean isBackground;

    public MetadataColorProvider(MetadataGroupType grpType, IStyleProvider stylePrv, boolean isBackground) {
        this.grpType = grpType;
        this.stylePrv = stylePrv;
        this.isBackground = isBackground;
    }

    public int determineColor(Object object) {
        if (object == null) {
            return 0xD0D0D0;
        }
        if (this.grpType == MetadataGroupType.OPAQUE) {
            if (object instanceof ItemClassIdentifiers) {
                this.grpType = MetadataGroupType.CLASSID;
            } else if (object instanceof Integer) {
                this.grpType = MetadataGroupType.RGB;
            }
        }
        switch (this.grpType) {
            case CLASSID: {
                int id;
                ItemClassIdentifiers classId;
                Style s;
                if (object instanceof ItemClassIdentifiers) {
                    object = ((ItemClassIdentifiers)((Object)object)).getId();
                }
                if (object instanceof Integer && this.stylePrv != null && (s = this.stylePrv.getStyle(classId = ItemClassIdentifiers.getById(id = ((Integer)object).intValue()), false)) != null) {
                    Color col;
                    Color color = col = this.isBackground ? s.getBackgroungColor() : s.getColor();
                    if (col != null) {
                        RGB r = col.getRGB();
                        return r.red << 16 | r.green << 8 | r.blue;
                    }
                }
                return 0x606060;
            }
            case RGB: {
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                return 0x606060;
            }
        }
        return 0x606060;
    }
}

