/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.output.text.IActionableTextItem;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.ITextMark;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.util.base.CharSequenceList;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineDelegate
implements ILine {
    private static final ILogger logger = GlobalLog.getLogger(LineDelegate.class);
    private ILine line;
    private CharSequence text;
    List<ITextItem> items = new ArrayList<ITextItem>();

    public LineDelegate(ILine line, int maxCharsPerLine, int charsEndLine) {
        this.line = line;
        this.text = CharSequenceList.getLine(line.getText(), maxCharsPerLine, charsEndLine);
        int lineLength = line.getText().length();
        for (ITextItem iTextItem : line.getItems()) {
            int length = iTextItem.getLength();
            int offset = iTextItem.getOffset();
            int endOfFirstSection = maxCharsPerLine - charsEndLine - 5;
            int startEndSection = lineLength - charsEndLine;
            int itemEndOffset = iTextItem.getOffset() + iTextItem.getLength();
            if (iTextItem.getOffset() < endOfFirstSection) {
                if (itemEndOffset >= endOfFirstSection) {
                    length = itemEndOffset >= startEndSection ? endOfFirstSection - iTextItem.getOffset() + 5 + (itemEndOffset - startEndSection) : endOfFirstSection - iTextItem.getOffset();
                    this.items.add(LineDelegate.buildNewItem(offset, length, (IActionableTextItem)iTextItem));
                    continue;
                }
                this.items.add(iTextItem);
                continue;
            }
            if (itemEndOffset < startEndSection) continue;
            if (iTextItem.getOffset() < startEndSection) {
                offset = maxCharsPerLine - charsEndLine;
                length -= startEndSection - iTextItem.getOffset();
            } else {
                offset = maxCharsPerLine - charsEndLine + (iTextItem.getOffset() - startEndSection);
            }
            this.items.add(LineDelegate.buildNewItem(offset, length, (IActionableTextItem)iTextItem));
        }
    }

    private static TextItem buildNewItem(int offset, int length, IActionableTextItem item) {
        return new TextItem(offset, length, item.getClassId(), item.getItemId(), item.getItemFlags());
    }

    @Override
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public List<? extends ITextItem> getItems() {
        return this.items;
    }

    @Override
    public List<? extends ITextMark> getMarks() {
        logger.debug("Marks retrieval in delegated lines is currently not implemented; will not fail, returning empty list instead", new Object[0]);
        return Collections.emptyList();
    }

    public ILine getDelegate() {
        return this.line;
    }
}

