/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.text;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.ITextItem;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.BufferPoint;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.UnwrappedBufferPoint;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentManager {
    private final ITextDocument doc;
    private ITextDocumentPart docPart;
    private boolean displayEolAtEod;
    public static final int defaultCharactersWrap = 80;
    private boolean wrapLines;
    private int wrapCount = -1;
    private int breakerBuffer = 10;
    private int breakerCancelLength = 6;
    private String wrapIndentString = "        ";
    private List<int[]> wrappedData = new ArrayList<int[]>();
    private Map<Integer, List<Integer>> wrapIndexes = new HashMap<Integer, List<Integer>>();
    private String docText;
    private List<RenderedItem> renderedItems = new ArrayList<RenderedItem>();
    private static Map<Character, Integer> breakers = new HashMap<Character, Integer>();

    public DocumentManager(ITextDocument doc) {
        this(doc, false);
    }

    public DocumentManager(ITextDocument doc, boolean displayEolAtEod) {
        this.doc = doc;
        this.displayEolAtEod = displayEolAtEod;
    }

    public void setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void setWrapCount(int wrapCount) {
        this.wrapCount = wrapCount;
    }

    public int getWrapCount() {
        return this.wrapCount;
    }

    public ITextDocumentPart getCurrentPart() {
        return this.docPart;
    }

    public void setCurrentPart(ITextDocumentPart docPart) {
        this.docPart = docPart;
        this.docText = this.buildTextInternal();
    }

    public String getText() {
        return this.docText;
    }

    public ITextDocument getDocument() {
        return this.doc;
    }

    public boolean isSingleAnchorDocument() {
        return this.doc.getAnchorCount() == 1L;
    }

    public long getAnchorRange() {
        return this.doc.getAnchorCount();
    }

    public long getAnchorFirst() {
        return this.doc.getFirstAnchor();
    }

    public long getAnchorEnd() {
        return this.doc.getFirstAnchor() + this.doc.getAnchorCount();
    }

    public ITextDocumentPart getPart(long anchorId, int linesAfter) {
        try {
            ITextDocumentPart newDocPart = this.doc.getDocumentPart(anchorId, linesAfter);
            return newDocPart;
        }
        catch (RuntimeException e) {
            throw new JebRuntimeException(Strings.f("Rendering Exception on part at %d,%d for %s", anchorId, linesAfter, this.getDocumentName()), e);
        }
    }

    public ITextDocumentPart getPart(long anchorId, int linesAfter, int linesBefore) {
        try {
            return this.doc.getDocumentPart(anchorId, linesAfter, linesBefore);
        }
        catch (RuntimeException e) {
            throw new JebRuntimeException(Strings.f("Rendering Exception on part at %d,%d,%d for %s", anchorId, linesAfter, linesBefore, this.getDocumentName()), e);
        }
    }

    public ITextDocumentPart getNonInteractivePartBetweenAnchors(long anchorId, long endAnchorId) {
        try {
            ArrayList<IAnchor> anchors2 = new ArrayList<IAnchor>();
            ArrayList<ILine> lines2 = new ArrayList<ILine>();
            long id0 = anchorId;
            block2: while (id0 < endAnchorId) {
                ITextDocumentPart p = this.doc.getDocumentPart(id0, 500);
                if (TextPartUtil.getFirstAnchorId(p) != id0) {
                    throw new RuntimeException("Unexpected first anchor");
                }
                for (IAnchor iAnchor : p.getAnchors()) {
                    long id = iAnchor.getIdentifier();
                    if (id >= endAnchorId) break block2;
                    Anchor a = new Anchor(id, lines2.size());
                    for (ILine iLine : TextPartUtil.getLinesOfAnchor(p, id)) {
                        lines2.add(new Line(iLine.getText()));
                    }
                    anchors2.add(a);
                }
                id0 = TextPartUtil.getNextAnchorId(p);
            }
            return new TextDocumentPart(lines2, anchors2);
        }
        catch (RuntimeException e) {
            throw new JebRuntimeException(Strings.f("Rendering Exception on part at %d for %s", anchorId, this.getDocumentName()), e);
        }
    }

    private String getDocumentName() {
        Object str = Strings.ff("%s [%d anchors]", this.doc.toString(), this.doc.getAnchorCount());
        IUnit unit = this.doc.getUnit();
        if (unit != null) {
            str = (String)str + Strings.ff(" (backed by: %s)", UnitUtil.buildFullyQualifiedUnitPath(unit));
        }
        return str;
    }

    public IAnchor getAnchorById(long anchorId) {
        if (this.getCurrentPart() == null) {
            return null;
        }
        return TextPartUtil.getAnchorById(this.getCurrentPart(), anchorId);
    }

    public int unwrapLine(int wrappedLineIndex) {
        if (wrappedLineIndex < 0 || wrappedLineIndex >= this.wrappedData.size()) {
            return -1;
        }
        return this.wrappedData.get(wrappedLineIndex)[0];
    }

    public UnwrappedBufferPoint unwrap(BufferPoint p) {
        int columnOffset;
        boolean eol;
        int wrappedLineIndex = p.getLineIndex();
        if (wrappedLineIndex < 0 || wrappedLineIndex >= this.wrappedData.size()) {
            return null;
        }
        int[] data = this.wrappedData.get(wrappedLineIndex);
        int lineIndex = data[0];
        int wrappedColumnOffset = p.getColumnOffset();
        boolean bl = eol = wrappedColumnOffset == data[2];
        if (data[1] == 0) {
            columnOffset = wrappedColumnOffset;
        } else {
            int currentWrapIndentSize = data[3];
            columnOffset = data[1] + Math.max(currentWrapIndentSize, wrappedColumnOffset) - currentWrapIndentSize;
        }
        return new UnwrappedBufferPoint(columnOffset, lineIndex, eol);
    }

    public int wrapLine(int lineIndex) {
        BufferPoint p = this.wrap(new UnwrappedBufferPoint(0, lineIndex, false));
        if (p == null) {
            return -1;
        }
        return p.getLineIndex();
    }

    public BufferPoint wrap(UnwrappedBufferPoint p) {
        int lineIndex = p.getLineIndex();
        int columnOffset = p.getColumnOffset();
        boolean eol = p.eol;
        List<Integer> indexes = this.wrapIndexes.get(p.getLineIndex());
        if (indexes == null || indexes.isEmpty()) {
            return null;
        }
        int i = indexes.get(0);
        int[] data = this.wrappedData.get(i);
        if (this.isEmptyLine(indexes) || indexes.size() == 1 || columnOffset < data[2] || eol && columnOffset == data[2]) {
            return new BufferPoint(columnOffset, i);
        }
        for (int j = 1; j < indexes.size() && (data = this.wrappedData.get(i = indexes.get(j).intValue()))[0] == lineIndex; ++j) {
            if (columnOffset < data[1] || columnOffset >= data[2] && (!eol || columnOffset != data[2])) continue;
            return new BufferPoint(columnOffset - data[1] + data[3], i);
        }
        return null;
    }

    private boolean isEmptyLine(List<Integer> indexes) {
        int i = indexes.get(0);
        int[] data = this.wrappedData.get(i);
        return indexes.size() == 1 && data.length == 3;
    }

    List<RenderedItem> getRenderedItems() {
        return this.renderedItems;
    }

    public int getLineCount() {
        return this.docPart.getLines().size();
    }

    public int getWrappedLineCount() {
        return this.wrappedData.size();
    }

    private String buildTextInternal() {
        this.wrappedData.clear();
        this.renderedItems.clear();
        this.wrapIndexes.clear();
        boolean appendTrailingEol = false;
        if (this.displayEolAtEod) {
            IAnchor lastAnchor = this.docPart.getAnchors().get(this.docPart.getAnchors().size() - 1);
            appendTrailingEol = lastAnchor.getIdentifier() >= this.getAnchorEnd() - 1L;
        }
        return this.buildText(this.docPart.getLines(), appendTrailingEol);
    }

    public String buildText(List<? extends ILine> lines) {
        return this.buildText(lines, true);
    }

    /*
     * WARNING - void declaration
     */
    private String buildText(List<? extends ILine> lines, boolean appendTrailingEol) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < lines.size(); ++index) {
            ILine line = lines.get(index);
            CharSequence text = line.getText();
            Object currentWrapIndentString = this.wrapIndentString;
            int currentWrapIndentSize = -1;
            if (text.length() == 0) {
                this.addIndex(index, this.wrappedData.size());
                this.wrappedData.add(new int[]{index, 0, 0});
            } else {
                int pos = 0;
                while (pos < text.length()) {
                    int brkPos;
                    int pos2 = this.wrapLines && this.wrapCount > 0 ? pos + this.wrapCount : text.length();
                    if (pos2 < text.length() && (brkPos = this.findBreaker(text, pos2)) >= 0 && brkPos - pos2 <= this.breakerBuffer) {
                        pos2 = brkPos;
                    }
                    if (pos2 >= text.length()) {
                        pos2 = text.length();
                    } else {
                        void var12_15;
                        List<? extends ITextItem> items = line.getItems();
                        boolean bl = false;
                        while (var12_15 < items.size()) {
                            ITextItem item = items.get((int)var12_15);
                            int off = item.getOffset();
                            if (pos2 > off && pos2 < off + item.getLength()) {
                                int nextItemThreshold;
                                int itemThreshold = off + item.getLength();
                                pos2 = this.findBreaker(text, itemThreshold, nextItemThreshold = var12_15 + true < items.size() ? items.get((int)(var12_15 + true)).getOffset() : -1);
                                if (pos2 >= 0) break;
                                pos2 = itemThreshold;
                                break;
                            }
                            if (pos2 < off) break;
                            ++var12_15;
                        }
                    }
                    if (text.length() - pos2 < this.breakerCancelLength) {
                        pos2 = text.length();
                    }
                    if (pos > 0) {
                        if (currentWrapIndentSize < 0) {
                            currentWrapIndentString = this.extractEmptyPrefix(text) + this.wrapIndentString;
                            currentWrapIndentSize = ((String)currentWrapIndentString).length();
                        }
                        sb.append('\n');
                        sb.append((String)currentWrapIndentString);
                    }
                    for (ITextItem iTextItem : line.getItems()) {
                        if (iTextItem.getOffset() < pos) continue;
                        if (iTextItem.getOffset() >= pos2) break;
                        int renderedItemOffset = sb.length() + (iTextItem.getOffset() - pos);
                        this.renderedItems.add(new RenderedItem(iTextItem, renderedItemOffset));
                    }
                    sb.append(text.subSequence(pos, pos2));
                    this.addIndex(index, this.wrappedData.size());
                    this.wrappedData.add(new int[]{index, pos, pos2, currentWrapIndentSize});
                    pos = pos2;
                }
            }
            if (index + 1 >= lines.size() && !appendTrailingEol) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private void addIndex(int key, int index) {
        Maps.putMulti(this.wrapIndexes, Integer.valueOf(key), index);
    }

    private int findBreaker(CharSequence text, int pos) {
        return this.findBreaker(text, pos, -1);
    }

    private int findBreaker(CharSequence text, int pos, int end) {
        if (end < 0 || end > text.length()) {
            end = text.length();
        }
        while (pos < end) {
            char c = text.charAt(pos);
            if (c == ' ' || c == '\t') {
                char c2;
                if (pos + 1 < end && breakers.containsKey(Character.valueOf(c2 = text.charAt(pos + 1)))) {
                    ++pos;
                    continue;
                }
                return pos;
            }
            Integer pi = breakers.get(Character.valueOf(c));
            if (pi != null) {
                int off = pi;
                if (pos + 1 < end) {
                    char c2 = text.charAt(pos + 1);
                    switch (c) {
                        case '=': {
                            if (c2 != '=') break;
                            off = 0;
                            break;
                        }
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '^': 
                        case '|': {
                            if (c2 != '=') break;
                            off = 2;
                        }
                    }
                }
                return pos + off;
            }
            ++pos;
        }
        return -1;
    }

    private CharSequence extractEmptyPrefix(CharSequence text) {
        char c;
        int pos;
        for (pos = 0; pos < text.length() && ((c = text.charAt(pos)) == ' ' || c == '\t'); ++pos) {
        }
        return text.subSequence(0, pos);
    }

    public void dispose() {
        this.wrappedData.clear();
        this.renderedItems.clear();
        this.wrapIndexes.clear();
    }

    static {
        breakers.put(Character.valueOf('+'), 0);
        breakers.put(Character.valueOf('-'), 0);
        breakers.put(Character.valueOf('*'), 0);
        breakers.put(Character.valueOf('/'), 0);
        breakers.put(Character.valueOf('%'), 0);
        breakers.put(Character.valueOf('|'), 0);
        breakers.put(Character.valueOf('&'), 0);
        breakers.put(Character.valueOf('^'), 0);
        breakers.put(Character.valueOf('~'), 0);
        breakers.put(Character.valueOf('<'), 0);
        breakers.put(Character.valueOf('>'), 0);
        breakers.put(Character.valueOf('!'), 0);
        breakers.put(Character.valueOf(':'), 0);
        breakers.put(Character.valueOf('?'), 0);
        breakers.put(Character.valueOf('='), 1);
        breakers.put(Character.valueOf(','), 1);
        breakers.put(Character.valueOf('('), 1);
        breakers.put(Character.valueOf('['), 1);
        breakers.put(Character.valueOf('{'), 1);
        breakers.put(Character.valueOf(';'), 1);
    }

    static class RenderedItem {
        public ITextItem item;
        public int offset;

        public RenderedItem(ITextItem item, int offset) {
            this.item = item;
            this.offset = offset;
        }
    }
}

