/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.table;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.table.ICell;
import com.pnfsoftware.jeb.core.output.table.ITableRow;
import com.pnfsoftware.jeb.core.output.table.IVisualCell;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.IStyleProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.table.InteractiveTableViewer;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;

class ColLabelProvider
extends CellLabelProvider
implements IFilteredLabelProvider {
    private InteractiveTableViewer viewer;

    public ColLabelProvider(InteractiveTableViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int index = cell.getColumnIndex();
        cell.setText(this.getText(element, index));
        cell.setBackground(this.getBackground(element, index));
        cell.setForeground(this.getForeground(element, index));
    }

    public String getText(Object element, int index) {
        ICell cell = ColLabelProvider.getCell(element, index);
        if (cell == null) {
            return null;
        }
        return Strings.replaceNewLines(cell.getLabel(), " / ");
    }

    public Color getForeground(Object element, int index) {
        Style style = this.getStyle(element, index);
        return style == null ? null : style.getColor();
    }

    public Color getBackground(Object element, int index) {
        Style style = this.getStyle(element, index);
        return style == null ? null : style.getBackgroungColor();
    }

    private static ICell getCell(Object element, int colIndex) {
        if (element == null) {
            return null;
        }
        List<? extends ICell> cells = ((ITableRow)element).getCells();
        if (cells == null) {
            return null;
        }
        if (colIndex >= cells.size()) {
            return null;
        }
        return cells.get(colIndex);
    }

    public Style getStyle(Object element, int colIndex) {
        ICell cell = ColLabelProvider.getCell(element, colIndex);
        if (!(cell instanceof IVisualCell)) {
            return null;
        }
        ItemClassIdentifiers classId = ((IVisualCell)cell).getClassId();
        if (classId == null) {
            return null;
        }
        IStyleProvider styleAdapter = this.viewer.getStyleAdapter();
        if (styleAdapter == null) {
            return null;
        }
        return styleAdapter.getStyle(cell);
    }

    @Override
    public String getStringAt(Object element, int key) {
        ICell cell = ColLabelProvider.getCell(element, key);
        if (cell == null) {
            return null;
        }
        return cell.getLabel();
    }

    @Override
    public Object[] getRowElements(Object row) {
        List<? extends ICell> cells = ((ITableRow)row).getCells();
        Object[] rowElements = new Object[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            rowElements[i] = cells.get(i).getLabel();
        }
        return rowElements;
    }
}

