/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers.hover.extend;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.IHoverableProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.extend.HoverableData;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.extend.HoverableHtml;
import com.pnfsoftware.jeb.rcpclient.iviewers.hover.extend.IHoverableWidget;
import com.pnfsoftware.jeb.rcpclient.util.GenericHistory;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JebInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
DisposeListener {
    private static final ILogger logger = GlobalLog.getLogger(JebInformationControl.class);
    private IHoverableWidget hoverable;
    private Composite contentComposite;
    private Browser fText;
    private ToolBarManager tbm;
    private Action actionBackward;
    private Action actionForward;
    private String information;
    private IHoverableProvider iHoverableProvider;
    private GenericHistory<Object> history = new GenericHistory();
    private JebLocationListener jebLocationListener;
    private List<File> temporaryFiles = new ArrayList<File>();

    public JebInformationControl(Shell parent, boolean isResizeable, IHoverableWidget hoverable) {
        super(parent, isResizeable);
        this.hoverable = hoverable;
        this.create();
    }

    public JebInformationControl(Shell parent, ToolBarManager toolBarManager, IHoverableWidget hoverable) {
        super(parent, toolBarManager);
        this.hoverable = hoverable;
        this.create();
    }

    @Override
    public void setInput(Object input) {
        input = this.preprocessInput(input);
        this.history.record(input);
        this.setInputInner(input);
        this.refreshButtons();
    }

    private void setInputInner(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else if (input instanceof HoverableData) {
            if (this.hoverable != null) {
                ((HoverableData)input).getData();
            }
        } else if (input instanceof InnerUrl) {
            this.jebLocationListener.ignoreNextUrl = true;
            this.fText.setUrl(((InnerUrl)input).url);
        } else {
            this.setInformation(Objects.toString(input));
        }
    }

    @Override
    public void setInformation(String information) {
        super.setInformation(information);
        this.fText.setText(information);
        this.information = information;
    }

    @Override
    protected void createContent(Composite parent) {
        this.contentComposite = parent;
        if (this.hoverable != null) {
        } else {
            Composite cop = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            cop.setLayout((Layout)gl);
            this.fText = new Browser(cop, 0);
            GridData gd = new GridData(4, 4, true, true);
            this.fText.setLayoutData((Object)gd);
            this.buildToolBarManager(cop);
        }
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            @Override
            public IInformationControl createInformationControl(Shell parent) {
                JebInformationControl jic = new JebInformationControl(parent, null, JebInformationControl.this.hoverable);
                jic.addLocationListener(JebInformationControl.this.iHoverableProvider);
                return jic;
            }
        };
    }

    public boolean hasToolBar() {
        return this.tbm != null;
    }

    private ToolBarManager buildToolBarManager(Composite parent) {
        this.actionBackward = UIUtil.createToolBarActionIcon("eclipse/backward_nav.png", () -> {
            this.setInputInner(this.history.backward());
            this.refreshButtons();
        });
        this.actionForward = UIUtil.createToolBarActionIcon("eclipse/forward_nav.png", () -> {
            this.setInputInner(this.history.forward());
            this.refreshButtons();
        });
        if (Licensing.isDebugBuild()) {
            Action copySourceCode = UIUtil.createToolBarActionIcon("jeb1/icon-export.png", () -> UIUtil.copyTextToClipboard(this.fText.getText()));
            this.tbm = UIUtil.createHorizontalToolBar(0, parent, this.actionBackward, this.actionForward, copySourceCode);
        } else {
            this.tbm = UIUtil.createHorizontalToolBar(0, parent, this.actionBackward, this.actionForward);
        }
        this.refreshButtons();
        return this.tbm;
    }

    private void refreshButtons() {
        if (!this.hasToolBar()) {
            return;
        }
        this.actionBackward.setEnabled(this.history.hasBackward());
        this.actionForward.setEnabled(this.history.hasForward());
        this.tbm.getControl().update();
    }

    @Override
    public boolean hasContents() {
        if (this.hoverable != null) {
            return this.hoverable.hasContents();
        }
        return this.information != null;
    }

    @Override
    public void dispose() {
        try {
            super.dispose();
        }
        catch (Exception e) {
            logger.catchingSilent(e);
        }
        for (File f : this.temporaryFiles) {
            f.delete();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
    }

    public void addLocationListener(IHoverableProvider iHoverableProvider) {
        this.iHoverableProvider = iHoverableProvider;
        if (this.fText != null && iHoverableProvider != null) {
            this.jebLocationListener = new JebLocationListener();
            this.fText.addLocationListener((LocationListener)this.jebLocationListener);
            this.fText.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    e.doit = false;
                }
            });
        }
    }

    private Object preprocessInput(Object o) {
        if (o instanceof HoverableHtml) {
            HoverableHtml html = (HoverableHtml)o;
            if (!OSType.determine().isWindows() && html.getAnchor() != null) {
                try {
                    File tmp = IO.createTempFile();
                    try {
                        IO.writeFile(tmp, html.getHtml());
                        this.temporaryFiles.add(tmp);
                        return new URI(tmp + "#" + IO.escapeFileName(html.getAnchor()).replace(" ", "%20"));
                    }
                    catch (IOException | URISyntaxException e) {
                        logger.catching(e);
                        tmp.delete();
                    }
                }
                catch (IOException e1) {
                    logger.catching(e1);
                }
            }
        }
        return o;
    }

    private static class InnerUrl {
        String url;

        public InnerUrl(String url) {
            this.url = url;
        }
    }

    private class JebLocationListener
    implements LocationListener {
        boolean ignoreNextUrl;
        private List<String> redirectPending = new ArrayList<String>();

        private JebLocationListener() {
        }

        public void changing(LocationEvent event) {
            String redirectKey = event.location;
            if (redirectKey.startsWith("file://")) {
                redirectKey = redirectKey.replace("%23", "#");
                if ((redirectKey = redirectKey.substring("file://".length())).length() > 3 && redirectKey.charAt(0) == '/' && redirectKey.charAt(2) == ':') {
                    redirectKey = redirectKey.substring(1);
                }
                if (redirectKey.charAt(1) == ':') {
                    redirectKey = redirectKey.replace('/', '\\');
                }
            }
            if (this.redirectPending.remove(redirectKey) || this.ignoreNextUrl) {
                return;
            }
            if (this.redirectPending.size() > 3) {
                this.redirectPending.clear();
                return;
            }
            Object obj = JebInformationControl.this.preprocessInput(JebInformationControl.this.iHoverableProvider.getHoverInfoOnLocationRequest(event.location, event.top));
            if (obj != null) {
                if (obj instanceof URI && !this.redirectPending.remove(event.location)) {
                    event.doit = false;
                    this.redirectPending.add(obj.toString());
                    JebInformationControl.this.fText.setUrl(obj.toString());
                    return;
                }
                JebInformationControl.this.setInput(obj);
                event.doit = false;
            }
        }

        public void changed(LocationEvent event) {
            if (!event.location.equals("about:blank") && event.top) {
                if (this.ignoreNextUrl) {
                    this.ignoreNextUrl = false;
                    return;
                }
                JebInformationControl.this.history.record(new InnerUrl(JebInformationControl.this.fText.getUrl()));
                JebInformationControl.this.refreshButtons();
            }
        }
    }
}

