/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import org.eclipse.swt.widgets.Shell;

public abstract class NativeCodeBaseHandler
extends JebBaseHandler {
    public NativeCodeBaseHandler(String id, String name, int accelerator) {
        super(id, name, 0, null, null, accelerator);
    }

    public NativeCodeBaseHandler(String id, String name, String tooltip, String icon, int accelerator) {
        super(id, name, 0, tooltip, icon, accelerator);
    }

    protected boolean canExecuteAndNativeCheck(IMPart part) {
        return this.canExecuteAndNativeCheck(part, false);
    }

    protected boolean canExecuteAndNativeCheck(IMPart part, boolean needValidAddress) {
        return this.canExecuteAndNativeCheck(part, needValidAddress, false);
    }

    protected boolean canExecuteAndNativeCheck(IMPart part, boolean needValidAddress, boolean exploreParents) {
        return this.canExecuteAndNativeCheck(part, needValidAddress, exploreParents, false);
    }

    protected boolean canExecuteAndNativeCheck(IMPart part, boolean needValidAddress, boolean exploreParents, boolean needExistingMethod) {
        if (part == null || this.isDisableHandlers(part)) {
            return false;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(part, exploreParents);
        if (pbcu == null || !pbcu.isProcessed()) {
            return false;
        }
        if (needValidAddress) {
            long memAddr = this.getActiveMemoryAddress(part, pbcu);
            if (memAddr == -1L || !this.canExecuteAt(pbcu, memAddr)) {
                return false;
            }
            if (needExistingMethod && pbcu.getInternalMethod(memAddr, false) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean canExecuteAt(INativeCodeUnit<?> pbcu, long memAddress) {
        return true;
    }

    public INativeCodeUnit<?> getNativeCodeUnit(IMPart part) {
        return this.getNativeCodeUnit(part, false);
    }

    public INativeCodeUnit<?> getNativeCodeUnit(IMPart part, boolean exploreParents) {
        if (part != null) {
            IUnit unit = NativeCodeBaseHandler.getActiveUnit(part);
            if (unit instanceof INativeCodeUnit) {
                return (INativeCodeUnit)unit;
            }
            if (exploreParents) {
                IDecompilerUnit decomp;
                if (unit instanceof INativeDecompilerUnit) {
                    return ((INativeDecompilerUnit)unit).getCodeUnit();
                }
                if (unit instanceof INativeSourceUnit && (decomp = ((INativeSourceUnit)unit).getDecompiler()) != null) {
                    return decomp.getCodeUnit();
                }
            }
        }
        return null;
    }

    public INativeDecompilerUnit<?> checkDecompiler(boolean alsoCheckChildOfPBCU, boolean createDecompilerIfNecessary) {
        IDecompilerUnit dec;
        if (this.part == null) {
            return null;
        }
        IUnit unit = this.getActiveUnit();
        if (unit instanceof INativeCodeUnit && (dec = DecompilerHelper.getDecompiler(unit, createDecompilerIfNecessary)) instanceof INativeDecompilerUnit) {
            return (INativeDecompilerUnit)dec;
        }
        while (!(unit instanceof INativeDecompilerUnit)) {
            if (unit == null) {
                return null;
            }
            if (!(unit.getParent() instanceof IUnit)) {
                return null;
            }
            unit = (IUnit)unit.getParent();
        }
        return (INativeDecompilerUnit)unit;
    }

    public long getActiveMemoryAddress(IMPart part, INativeCodeUnit<?> unit) {
        return this.getActiveMemoryAddress(part, unit, false);
    }

    public long getActiveMemoryAddress(IMPart part, INativeCodeUnit<?> unit, boolean preferItemAddress) {
        long a1;
        String itemAddr;
        long itemId;
        JebAddress address = NativeCodeBaseHandler.getActiveAddress(part, AddressConversionPrecision.COARSE);
        long a = -1L;
        if (address != null) {
            a = unit.getCanonicalMemoryAddress(address.getAddress(), address.getPrecision());
        }
        if ((a == -1L || preferItemAddress) && (itemId = NativeCodeBaseHandler.getActiveItemId(part)) != 0L && (itemAddr = unit.getAddressOfItem(itemId)) != null && (a1 = unit.getCanonicalMemoryAddress(itemAddr)) != -1L) {
            a = a1;
        }
        return a;
    }

    public void notifyUnit(IUnit unit) {
        unit.notifyListeners(new JebEvent(J.UnitChange));
    }

    public void postExecute() {
        this.getShell();
    }

    public static void postExecute(Shell shell) {
    }
}

