/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstant;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantFactory;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantFloat;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantFloat32;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantFloat64;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantInteger;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICExpression;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.EEmulator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.emulator.MemoryWrites;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.EmuSettingsDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class IREmulatorGraphicalManager {
    private static final ILogger logger = GlobalLog.getLogger(IREmulatorGraphicalManager.class);
    private Shell shell;
    private IMPart part;
    private RcpClientContext context;

    public IREmulatorGraphicalManager(Shell shell, IMPart part, RcpClientContext context) {
        this.shell = shell;
        this.part = part;
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(boolean quick) {
        int i;
        boolean postUpdateAST0;
        boolean postDisplayMods0;
        boolean recordMemWrites0;
        boolean resetOtherRegisters0;
        boolean allowOpt0;
        int maxIterCount0;
        INativeSourceUnit src = null;
        ICCall call = null;
        INativeMethodItem m = null;
        IItem item = JebBaseHandler.getActiveItem(this.part);
        if (item instanceof IActionableItem) {
            Object o;
            IActionableItem aitem = (IActionableItem)((Object)item);
            IUnit unit = JebBaseHandler.getActiveUnit(this.part);
            if (unit instanceof INativeSourceUnit && (o = (src = (INativeSourceUnit)unit).getItemObject(aitem.getItemId())) instanceof INativeMethodItem) {
                List<Object> objects;
                m = (INativeMethodItem)o;
                UnitPartManager pman = (UnitPartManager)this.part.getManager();
                IUnitFragment f = pman.getActiveFragment();
                if (f instanceof AbstractTextFragment && !(objects = ((AbstractTextFragment)f).getViewer().getDocumentObjectsAtCaret()).isEmpty() && (o = objects.get(objects.size() - 1)) instanceof ICCall) {
                    call = (ICCall)o;
                }
            }
        }
        if (call == null) {
            return false;
        }
        IDecompilerUnit decomp = src.getDecompiler();
        IEGlobalContext gctx = decomp.getGlobalContext();
        ICodeUnit pbcu = decomp.getCodeUnit();
        ITypeManager typeman = pbcu.getTypeManager();
        IPrototypeItem proto = EEmulator.retrievePrototype((INativeDecompilerContext)((Object)decomp), m);
        if (proto == null) {
            UI.warn(this.shell, "Missing prototype", Strings.ff("Method %s has no prototype! A prototype is a pre-requisite for emulation.\n\nEdit the method prototype manually, or decompile the method to let JEB set one automatically.", m.getAddress()));
            return false;
        }
        (new Object[1])[0] = call;
        StringBuilder params = new StringBuilder();
        for (ICExpression arg : call.getArguments()) {
            if (arg instanceof ICConstant) {
                Strings.ff(params, "%s\n", arg);
                continue;
            }
            Strings.ff(params, "?\n", new Object[0]);
            if (!quick) continue;
            logger.debug("Cannot do quick emulation: not all parameters to the CCall are CConstants: '%s'. Reverting to emulation with settings...", call);
            quick = false;
        }
        IPropertyManager pm = this.context.getPropertyManager();
        if (pm.getIntegerUnsafe(".ui.native.emu.MaxIterCount") == null) {
            maxIterCount0 = 10000;
            allowOpt0 = false;
            resetOtherRegisters0 = true;
            recordMemWrites0 = false;
            postDisplayMods0 = true;
            postUpdateAST0 = false;
        } else {
            maxIterCount0 = pm.getInteger(".ui.native.emu.MaxIterCount");
            allowOpt0 = pm.getBoolean(".ui.native.emu.AllowOpt");
            resetOtherRegisters0 = pm.getBoolean(".ui.native.emu.ResetOtherRegisters");
            recordMemWrites0 = pm.getBoolean(".ui.native.emu.RecordMemoryWrites");
            postDisplayMods0 = pm.getBoolean(".ui.native.emu.PostDisplayMods");
            postUpdateAST0 = pm.getBoolean(".ui.native.emu.PostUpdateAST");
        }
        ArrayList<IEImm> args = new ArrayList<IEImm>();
        if (!quick) {
            EmuSettingsDialog dlg = new EmuSettingsDialog(this.shell);
            dlg.setTargetRoutineAddress(m.getAddress());
            dlg.setParameters(params.toString());
            dlg.setMaxIterCount(maxIterCount0);
            dlg.setAllowOpt(allowOpt0);
            dlg.setResetOtherRegisters(resetOtherRegisters0);
            dlg.setRecordMemWrites(recordMemWrites0);
            dlg.setDisplayMods(postDisplayMods0);
            dlg.setUpdateAST(postUpdateAST0);
            if (!dlg.open().booleanValue()) {
                return false;
            }
            m = pbcu.getMethod(dlg.getTargetRoutineAddress());
            if (m == null) {
                logger.warn("Unknown method: %s", dlg.getTargetRoutineAddress());
                return false;
            }
            maxIterCount0 = dlg.getMaxIterCount();
            allowOpt0 = dlg.getAllowOpt();
            resetOtherRegisters0 = dlg.getResetOtherRegisters();
            recordMemWrites0 = dlg.getRecordMemWrites();
            postDisplayMods0 = dlg.getDisplayMods();
            postUpdateAST0 = dlg.getUpdateAST();
            pm.setInteger(".ui.native.emu.MaxIterCount", maxIterCount0);
            pm.setBoolean(".ui.native.emu.AllowOpt", allowOpt0);
            pm.setBoolean(".ui.native.emu.ResetOtherRegisters", resetOtherRegisters0);
            pm.setBoolean(".ui.native.emu.RecordMemoryWrites", recordMemWrites0);
            pm.setBoolean(".ui.native.emu.PostDisplayMods", postDisplayMods0);
            pm.setBoolean(".ui.native.emu.PostUpdateAST", postUpdateAST0);
            List<? extends INativeType> types = proto.getParameterTypes();
            i = 0;
            for (String line : Strings.splitLines(dlg.getParameters())) {
                if ((line = line.trim()).startsWith(";") || Strings.isBlank(line)) continue;
                Object t = typeman.getType("int");
                if (i < types.size()) {
                    t = types.get(i);
                }
                if (TypeUtil.isInteger((INativeType)(t = TypeUtil.getNonAlias((INativeType)t)))) {
                    long v = Conversion.stringToLong(line);
                    args.add(gctx.createImm(v, t.getBitsize()));
                } else {
                    if (!TypeUtil.isFloat((INativeType)t)) {
                        logger.warn("Unsupported", new Object[0]);
                        return false;
                    }
                    if (t.getSize() == 4) {
                        float v = Float.parseFloat(line);
                        args.add(gctx.createImm(v));
                    } else {
                        if (t.getSize() != 8) {
                            logger.warn("Unsupported", new Object[0]);
                            return false;
                        }
                        double v = Double.parseDouble(line);
                        args.add(gctx.createImm(v));
                    }
                }
                ++i;
            }
        } else {
            postDisplayMods0 = false;
            postUpdateAST0 = true;
            List<? extends INativeType> types = proto.getParameterTypes();
            int i2 = 0;
            for (ICExpression e : call.getArguments()) {
                INativeType t = typeman.getType("int");
                if (i2 < types.size()) {
                    t = types.get(i2);
                }
                t = TypeUtil.getNonAlias(t);
                ICConstant c = (ICConstant)e;
                if (TypeUtil.isInteger(t)) {
                    if (!(c instanceof ICConstantInteger)) {
                        logger.warn("Unsupported", new Object[0]);
                        return false;
                    }
                    BigInteger v = ((ICConstantInteger)c).getIntegerValue();
                    args.add(gctx.createImm(v, t.getBitsize()));
                } else {
                    if (!TypeUtil.isFloat(t)) {
                        logger.warn("Unsupported", new Object[0]);
                        return false;
                    }
                    if (!(c instanceof ICConstantFloat)) {
                        return false;
                    }
                    if (c instanceof ICConstantFloat32) {
                        float v = ((ICConstantFloat32)c).getFP32Value();
                        args.add(gctx.createImm(v));
                    } else {
                        if (!(c instanceof ICConstantFloat64)) {
                            logger.warn("Unsupported", new Object[0]);
                            return false;
                        }
                        double v = ((ICConstantFloat64)c).getFP64Value();
                        args.add(gctx.createImm(v));
                    }
                }
                ++i2;
            }
        }
        EEmulator emu = EEmulator.createStandard(gctx, maxIterCount0);
        emu.setTargetRoutine(m);
        emu.setArguments(args);
        emu.setResetUnknownRegisters(resetOtherRegisters0);
        emu.setRecordMemoryWrites(recordMemWrites0);
        emu.setup();
        try {
            boolean hasReturn;
            try {
                emu.run();
            }
            catch (Exception e) {
                logger.error("Emulation failed: %s", e.getMessage());
                i = 0;
                emu.teardown();
                return i != 0;
            }
            INativeType rettype = proto.getReturnType();
            rettype = TypeUtil.getNonAlias(rettype);
            boolean bl = hasReturn = !TypeUtil.isVoid(rettype);
            if (postDisplayMods0) {
                StringBuilder sb = new StringBuilder();
                EState state = emu.getState();
                IVirtualMemory mem = state.getMemory();
                byte[] buf = new byte[64];
                Strings.ff(sb, "Modified registers:\n", new Object[0]);
                for (IEVar reg : gctx.getAllRegisters()) {
                    int len;
                    long addr;
                    IEImm val;
                    if (reg.getBitsize() < 8 || !state.hasValue(reg.getId()) || (val = state.getValue(reg)).isZero()) continue;
                    BigInteger v = val.getValue();
                    Strings.ff(sb, "%s: %s (0x%s)", reg.getName(), v, v.toString(16).toUpperCase());
                    if (val.canReadAsAddress() && VirtualMemoryUtil.isPageAllocated(mem, addr = val.getValueAsAddress()) && (len = VirtualMemoryUtil.readBytesSafe(mem, addr, buf.length, buf, 0, true)) > 0 && (len = IREmulatorGraphicalManager.lengthWithoutTrailingZeroes(buf)) > 0) {
                        String s = Formatter.escapeBytes(buf, 0, len);
                        Strings.ff(sb, " -> \"%s\"...", s);
                    }
                    Strings.ff(sb, "\n", new Object[0]);
                }
                Strings.ff(sb, "\n", new Object[0]);
                if (!recordMemWrites0) {
                    Strings.ff(sb, "(Memory writes were not recorded)\n", new Object[0]);
                } else {
                    MemoryWrites mw = emu.getMemoryWrites();
                    byte[] bytes = mw.getAggregatedWrittenBytes();
                    Strings.ff(sb, "Aggregated writes (all bytes written to memory):\n%s\n", Formatter.formatBinaryBlock(bytes));
                    int cnt = mw.getCountOfRecords();
                    Strings.ff(sb, "%d memory writes recorded:\n", cnt);
                    for (int i3 = 0; i3 < cnt; ++i3) {
                        MemoryWrites.Record r = mw.getRecord(i3);
                        Strings.ff(sb, "0x%X: %s\n", r.getAddress(), Formatter.escapeBytes(r.getData()));
                    }
                }
                TextDialog dlgmem = new TextDialog(this.shell, "Registers and Memory Writes", sb.toString(), null);
                dlgmem.setEditable(false);
                dlgmem.setFont(this.context.getFontManager().getCodeFont());
                dlgmem.setColumnCount(80);
                dlgmem.setLineCount(30);
                dlgmem.open();
            }
            if (!hasReturn) return true;
            StorageEntry entry = proto.getCallingConvention().getOutput(TypeUtil.getLayoutInfo(rettype), 0);
            IEImm retval = emu.readStorage(entry);
            if (!quick) {
                UI.info(this.shell, "Return value", "Emulated routine returned: " + retval.getValue());
            }
            if (!postUpdateAST0) return true;
            ICConstantInteger<?> repl = null;
            ICConstantFactory cf = decomp.getHighLevelContext().getConstantFactory();
            if (TypeUtil.isInteger(rettype)) {
                repl = cf.createInt(retval.getValue(), rettype.getBitsize());
            } else {
                logger.error("Cannot generate replacement AST element for returned value", new Object[0]);
            }
            if (repl == null) return true;
            ICElement parent = CUtil.findParent(src.getASTItem(), call);
            if (parent == null) return true;
            boolean proceed = quick || UI.question(this.shell, "AST node replacement", Strings.ff("Replace node '%s' by '%s' ?", call, repl));
            if (!proceed) return true;
            if (!parent.replaceSubElement(call, repl)) return true;
            UnitUtil.notifyGenericChange(src);
            return true;
        }
        finally {
            emu.teardown();
        }
    }

    private static int lengthWithoutTrailingZeroes(byte[] buf) {
        int i;
        for (i = buf.length - 1; i >= 0 && buf[i] == 0; --i) {
        }
        return i + 1;
    }
}

