/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.RoutineSignatureEditorDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionGenericHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Iterator;

public class ActionEditTypeHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionEditTypeHandler.class);
    boolean preferMethodProtoOverSignature = false;

    public ActionEditTypeHandler() {
        super("editType", S.s(495), 89);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true, true);
    }

    @Override
    public void execute() {
        TypeLibraryService tlsvc;
        boolean insideMethod;
        long a;
        ActionUIContext uictx;
        long itemId = ActionEditTypeHandler.getActiveItemId(this.part);
        if (itemId != 0L && (uictx = ActionGenericHandler.prepare(this.part, 15)) != null) {
            GraphicalActionExecutor executor = new GraphicalActionExecutor(this.getShell(), this.context);
            if (executor.execute(uictx)) {
                return;
            }
            return;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part, true);
        INativeMethodItem m = pbcu.getInternalMethod(a = this.getActiveMemoryAddress(this.part, pbcu, true), true);
        if (m != null) {
            RoutineSignatureEditorDialog dlg = new RoutineSignatureEditorDialog(this.getShell(), pbcu, m);
            dlg.open();
            return;
        }
        boolean bl = insideMethod = pbcu.getInternalMethod(a, false) != null;
        if (insideMethod) {
            return;
        }
        String target = Strings.ff("Item at address 0x%X", a);
        INativeType type = pbcu.getDataTypeAt(a);
        String currentTypestr = type == null ? null : type.getSignature(true);
        TextHistory historyData = this.context.getTextHistoryData().get("nativeTypesHistory");
        NativeTypeDialog dlg = new NativeTypeDialog(this.getShell(), 0, target, historyData, pbcu);
        dlg.setInitialValue(currentTypestr);
        String typestr = dlg.open();
        if (typestr == null) {
            return;
        }
        ITypeManager typeman = pbcu.getTypeManager();
        INativeType t = typeman.getType(typestr);
        if (t == null && (t = Lists.getFirst(TypeUtil.findType(pbcu.getTypeManager().getTypes(), typestr, true))) == null && (tlsvc = pbcu.getTypeLibraryService()) != null) {
            ITypeLibrary typelib;
            Iterator<ITypeLibrary> iterator = tlsvc.getLoadedTypeLibraries().iterator();
            while (iterator.hasNext() && (t = Lists.getFirst(TypeUtil.findType((typelib = iterator.next()).getTypes(), typestr, true))) == null) {
            }
        }
        if (t == null) {
            logger.error("Type not found: %s", typestr);
            return;
        }
        if (!pbcu.setDataTypeAt(a, t)) {
            logger.error("Failed to update type at address %Xh", a);
        }
        this.postExecute();
    }
}

