/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.CodeSetupInformation;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.DefineCodeDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.SortedMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

public class ActionEditCodeHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionEditCodeHandler.class);

    public ActionEditCodeHandler() {
        super("editCode", "Disassemble Instructions...", SWT.MOD1 | SWT.MOD3 | 0x43);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true);
    }

    @Override
    public void execute() {
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        long a = this.getActiveMemoryAddress(this.part, pbcu);
        DefineCodeDialog dlg = new DefineCodeDialog(this.getShell(), a, pbcu);
        CodeSetupInformation info = dlg.open();
        if (info == null) {
            return;
        }
        if (!ActionEditCodeHandler.disassemble(this.getShell(), pbcu, info)) {
            logger.error("Failed to define code at address %Xh", a);
        }
        this.postExecute();
    }

    static boolean disassemble(Shell shell, INativeCodeUnit<? extends IInstruction> pbcu, CodeSetupInformation info) {
        int cnt;
        boolean doNotAsk = false;
        boolean doUndefine = false;
        long address = info.getAddress();
        boolean needsAdaptivePopup = info.getMaxInstructionCount() > 1;
        for (cnt = 0; info.getMaxInstructionCount() == -1 || cnt < info.getMaxInstructionCount(); ++cnt) {
            boolean r = pbcu.setCodeAt(address, info.getProcessorMode(), doUndefine);
            if (!r) {
                boolean undef;
                boolean needsOverride;
                if (doUndefine || doNotAsk) break;
                boolean bl = needsOverride = pbcu.getNativeItemAt(address) != null;
                if (!needsOverride) {
                    int insnSize;
                    SortedMap<Long, INativeContinuousItem> natives;
                    IInstruction insn;
                    try {
                        insn = pbcu.getProcessor().parseAt(pbcu.getMemory(), address);
                    }
                    catch (ProcessorException processorException) {
                        break;
                    }
                    if (insn != null && (natives = pbcu.getNativeItemsOver(address, insnSize = insn.getSize())) != null && !natives.isEmpty()) {
                        needsOverride = true;
                    }
                }
                if (!needsOverride) break;
                String msg = Strings.ff("Undefine existing items to create an instruction item?\n\nAddress: 0x%X", address);
                if (!needsAdaptivePopup) {
                    undef = UI.question(shell, S.s(207), msg);
                } else {
                    AdaptivePopupDialog dlg = AdaptivePopupDialog.question(shell, S.s(207), msg);
                    undef = dlg.open() == 1;
                    doNotAsk = dlg.isDoNotShow();
                    if (doNotAsk) {
                        doUndefine = undef;
                    }
                }
                if (undef) {
                    r = pbcu.setCodeAt(address, info.getProcessorMode(), true);
                }
            }
            if (!r) break;
            INativeContinuousItem item = pbcu.getNativeItemAt(address);
            if (item == null || !(item instanceof INativeInstructionItem)) {
                logger.error("Expected an instruction item at address %Xh, instead got: %s", address, item);
                break;
            }
            address += item.getMemorySize();
        }
        return cnt >= 1;
    }
}

