/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class ActionDefineProcedureHandler
extends NativeCodeBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionDefineProcedureHandler.class);

    public ActionDefineProcedureHandler() {
        super("defineProcedure", "Create Procedure", 80);
    }

    @Override
    public boolean canExecute() {
        return this.canExecuteAndNativeCheck(this.part, true);
    }

    @Override
    public void execute() {
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        long a = this.getActiveMemoryAddress(this.part, pbcu);
        if (!pbcu.isAnalysisCompleted()) {
            UI.warn("Please wait for the code analysis to complete before attempting to define new methods.");
            return;
        }
        int procmode = 0;
        INativeContinuousItem item = pbcu.getNativeItemAt(a);
        if (item != null && item instanceof INativeInstructionItem) {
            procmode = ((INativeInstructionItem)item).getInstruction().getProcessorMode();
        }
        if (!pbcu.setRoutineAt(a, procmode)) {
            UI.error(Strings.ff("Failed to define routine at address %Xh", a));
        }
        this.postExecute();
    }
}

