/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.ListMatchedCodelessSigDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;

public class ActionCodelessSigsHandler
extends JebBaseHandler {
    public ActionCodelessSigsHandler() {
        super(null, "Codeless Signature Libraries...", null, null);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null && this.context.getEnginesContext().getCodelessSignatureManager() != null && !this.context.getEnginesContext().getCodelessSignatureManager().getAvailablePackages().isEmpty();
    }

    @Override
    public void execute() {
        this.context.getTelemetry().record("actionCodelessSigHandler");
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        String msg = Strings.f("Codeless signatures are an experimental feature for identifying common native libraries in a compiler/architecture independent fashion%n%nThree types of identification can happen on a target routine:%n%n- unique match: target routine will be renamed with its corresponding library routine's name, prefixed with library and module names, e.g. 'OpenSSL::aes-586.obj::_AES_decrypt'%n%n- multiple matches: target routine is renamed 'unk' -- possibly with a specific module name --, e.g. 'OpenSSL::aes-586.obj::unk' and each call to target is commented with the candidates names%n%n- no matches: target routine belongs to a known library, but no specific names could be found; target routine is renamed 'unk' prefixed by library name, e.g. 'OpenSSL::unk::unk'", new Object[0]);
        UI.infoOptional(this.getShell(), "Codeless Signatures Information", msg, "matchedCodelessSigsInfoDialog");
        ListMatchedCodelessSigDialog dlg = new ListMatchedCodelessSigDialog(this.getShell(), this.context);
        dlg.setInput(engctx.getCodelessSignatureManager());
        dlg.open();
    }
}

