/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.NativeCodeUtil;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IClassRebuilder;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.concurrent.Callable;

public class ActionClassRecoveryHandler
extends NativeCodeBaseHandler {
    public ActionClassRecoveryHandler() {
        super("classRecovery", "C++ Class Recovery", 0);
    }

    @Override
    public boolean canExecute() {
        if (!this.canExecuteAndNativeCheck(this.part, false)) {
            return false;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        if (pbcu == null) {
            return false;
        }
        return pbcu.isAnalysisCompleted();
    }

    @Override
    public void execute() {
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        if (pbcu == null) {
            return;
        }
        final IClassRebuilder cr = NativeCodeUtil.createClassRebuilder(pbcu);
        if (cr == null) {
            return;
        }
        this.context.executeTaskWithPopupDelay(1000, "Please wait...", false, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int cnt;
                if (cr.quickDetermination() && (cnt = cr.process()) >= 1) {
                    UI.info(Strings.ff("Recovered %d %s", cnt, PluralFormatter.count(cnt, "class", "classes")));
                }
                return true;
            }
        });
        this.postExecute();
    }
}

