/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.internal;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.swt.SWT;

public class InternalSimulateDecompilationsHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(InternalSimulateDecompilationsHandler.class, 30);

    public InternalSimulateDecompilationsHandler() {
        super(null, "Simulate Decompilations", null, null);
        this.setAccelerator(SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | 0x44);
    }

    @Override
    public boolean canExecute() {
        return this.getActiveUnit() instanceof ICodeUnit;
    }

    @Override
    public void execute() {
        IUnit unit = this.getActiveUnit();
        if (!(unit instanceof ICodeUnit)) {
            return;
        }
        ICodeUnit code = (ICodeUnit)unit;
        IDecompilerUnit decomp = DecompilerHelper.getDecompiler(code);
        GlobalLog.addGlobalFilter("", 30);
        long t0 = System.currentTimeMillis();
        try {
            List<? extends ICodeClass> clist = code.getClasses();
            int i = 0;
            int cnt = 0;
            for (ICodeClass iCodeClass : clist) {
                ++i;
                if (!iCodeClass.isInternal() || (iCodeClass.getGenericFlags() & 0x100000) != 0) continue;
                String csig = iCodeClass.getSignature();
                logger.info("DECOMPILING: %d/%d: %s", i, clist.size(), csig);
                HandlerUtil.decompileAsync(this.getShell(), this.context, decomp, csig);
                ++cnt;
                if (!IO.createTempFile("DECOMP.STOP").exists()) continue;
                break;
            }
            long exectime = System.currentTimeMillis() - t0;
            UI.info(Strings.ff("Decompiled %d top-level classes in %s", cnt, TimeFormatter.formatTimestampDelta(exectime)));
        }
        finally {
            GlobalLog.removeGlobalFilter("");
        }
    }
}

