/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.help;

import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.base.RunnableWithProgressCallback;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class HelpChangeUpdateChannelHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(HelpChangeUpdateChannelHandler.class);
    int channelId;

    public HelpChangeUpdateChannelHandler(String name, int channelId) {
        super(null, name, 2, null, null, 0);
        this.channelId = channelId;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public void execute() {
        if (this.context.getUpdateChannel() == this.channelId) {
            return;
        }
        this.context.setUpdateChannel(this.channelId);
        this.context.getTelemetry().record("updateChannelChange", "channelId", "" + this.channelId);
        String msg = Strings.ff("You will receive updates on the %s channel%s.\n\nWould you like to check for updates right away?", Version.getChannelName(this.channelId), this.channelId == 0 ? "" : " and above");
        if (UI.question(this.getShell(), "JEB Update Channel", msg)) {
            this.context.executeTask("Checking for update", new RunnableWithProgressCallback(){

                @Override
                public void run() {
                    HelpChangeUpdateChannelHandler.this.context.checkUpdate(true, false, this.callback, true);
                }
            });
        }
    }
}

