/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.scripts;

import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.KeyShortcutsManager;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.GenericScriptHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptEntry;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptMetadata;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.bindings.keys.KeyStroke;

public class ScriptManager {
    private static final ILogger logger = GlobalLog.getLogger(ScriptManager.class);
    public static final ScriptManager EMPTY = new ScriptManager();
    private Path scriptsRootPath;
    private WatchService watcher;
    IdentityHashMap<WatchKey, Path> wkmap = new IdentityHashMap();
    private Thread thread;
    private Map<File, ScriptEntry> scriptEntries = new ConcurrentHashMap<File, ScriptEntry>();

    private ScriptManager() {
    }

    public ScriptManager(File scriptsFolder, boolean watch) throws IOException {
        if (scriptsFolder == null) {
            throw new IllegalArgumentException("Null scripts folder");
        }
        this.setScriptsFolder(scriptsFolder, watch);
    }

    public File getScriptsFolder() {
        if (this.scriptsRootPath == null) {
            return null;
        }
        return this.scriptsRootPath.toFile();
    }

    public synchronized void setScriptsFolder(File scriptsFolder, boolean watch) throws IOException {
        if (!this.stop()) {
            throw new IOException("Cannot change scripts folder");
        }
        this.scriptEntries.clear();
        this.scriptsRootPath = scriptsFolder.toPath();
        this.scan();
        if (watch) {
            this.watcher = FileSystems.getDefault().newWatchService();
            try {
                Files.walkFileTree(this.scriptsRootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String relname = ScriptManager.this.scriptsRootPath.relativize(dir).toString();
                        if (relname != null && relname.startsWith(".")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        WatchKey key = dir.register(ScriptManager.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        ScriptManager.this.wkmap.put(key, dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                try {
                    this.watcher.close();
                }
                catch (IOException iOException) {}
                throw e;
            }
            this.thread = ThreadUtil.start(new Monitor());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean stop() {
        if (this.thread == null) {
            return true;
        }
        this.thread.interrupt();
        try {
            this.thread.join();
            this.thread = null;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        try {
            for (WatchKey key : this.wkmap.keySet()) {
                key.cancel();
            }
            this.wkmap.clear();
        }
        catch (Throwable throwable) {
            try {
                if (this.watcher == null) throw throwable;
                this.watcher.close();
                this.watcher = null;
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            if (this.watcher == null) return true;
            this.watcher.close();
            this.watcher = null;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void scan() {
        try {
            Files.walkFileTree(this.scriptsRootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String relname = ScriptManager.this.scriptsRootPath.relativize(dir).toString();
                    if (relname != null && relname.startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    File f = file.toFile();
                    if (f.isFile() && f.getName().endsWith(".py")) {
                        try {
                            ScriptManager.this.processFile(f, StandardWatchEventKinds.ENTRY_CREATE);
                        }
                        catch (Exception e) {
                            logger.catching(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            logger.catching(ex);
        }
    }

    private boolean processFile(File file, WatchEvent.Kind<?> kind) {
        boolean bl;
        if (!file.getName().endsWith(".py")) {
            return false;
        }
        Object[] objectArray = new Object[]{kind, file};
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.unregisterScript(file);
            return true;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
        try {
            String line;
            ScriptMetadata md = new ScriptMetadata();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (!line.startsWith("#")) break;
                if (!line.startsWith("#?")) continue;
                this.processScriptMetadata(file, line.substring(2).trim(), md);
            }
            this.registerScript(file, md);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        br.close();
        return bl;
    }

    private boolean processScriptMetadata(File file, String s, ScriptMetadata md) {
        String pfx = "description=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            if (!value.isEmpty()) {
                md.description = value;
            }
            return true;
        }
        pfx = "author=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            if (!value.isEmpty()) {
                md.author = value;
            }
            return true;
        }
        pfx = "version=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            if (!value.isEmpty()) {
                Version version = Version.parseFromString(value);
                if (version == null) {
                    logger.error("Script %s: Invalid version number: %s", file, value);
                    return false;
                }
                md.version = version;
            }
            return true;
        }
        pfx = "shortcut=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            if (!value.isEmpty()) {
                int shortcut = KeyShortcutsManager.parseShortcut(value);
                if (shortcut == 0) {
                    logger.error("Script %s: Invalid keyboard shortcut: %s", file, value);
                    return false;
                }
                KeyStroke ks = KeyShortcutsManager.parseShortcutToKeystroke(value);
                if (ks == null) {
                    logger.error("Script %s: Invalid keyboard shortcut: %s", file, value);
                    return false;
                }
                md.shortcutCode = shortcut;
                md.shortcutString = ks.toString();
            }
            return true;
        }
        if (s.startsWith("deprecated=") || s.equals("deprecated")) {
            md.deprecated = true;
            return true;
        }
        if (s.startsWith("nolist=") || s.equals("nolist")) {
            md.nolist = true;
            return true;
        }
        pfx = "autorun=";
        if (s.startsWith(pfx)) {
            int autorunFlags = 0;
            String value = s.substring(pfx.length()).trim();
            block9: for (String val : value.split(",")) {
                int v;
                try {
                    v = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    v = -1;
                }
                switch (v) {
                    case 1: {
                        autorunFlags |= 1;
                        continue block9;
                    }
                    case 2: {
                        autorunFlags |= 2;
                        continue block9;
                    }
                    case 3: {
                        autorunFlags |= 4;
                        continue block9;
                    }
                    default: {
                        logger.error("Script %s: Illegal value for autorun: '%s'", file, value);
                        return false;
                    }
                }
            }
            md.autorunFlags = autorunFlags;
            return true;
        }
        pfx = "autorun_priority=";
        if (s.startsWith(pfx)) {
            String value = s.substring(pfx.length()).trim();
            try {
                md.autorunPriority = Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("Script %s: Illegal value for autorun_priority: '%s'", file, value);
                return false;
            }
        }
        logger.warn("Unknown script metadata: '%s'", s);
        return false;
    }

    private void registerScript(File file, ScriptMetadata md) {
        final ScriptEntry entry = new ScriptEntry(file, md);
        final ScriptEntry previousEntry = this.scriptEntries.get(file);
        if (entry.equals(previousEntry)) {
            return;
        }
        final RcpClientContext ctx = RcpClientContext.getInstance();
        if (ctx != null) {
            UIExecutor.sync(ctx.getDisplay(), new Runnable(){

                @Override
                public void run() {
                    if (previousEntry != null && previousEntry.handler != null) {
                        ctx.getKeyAccelaratorManager().unregisterHandler(previousEntry.handler);
                    }
                    GenericScriptHandler handler = new GenericScriptHandler(entry);
                    ctx.getKeyAccelaratorManager().registerHandler(handler);
                    entry.handler = handler;
                }
            });
        }
        this.scriptEntries.put(entry.file, entry);
    }

    private void unregisterScript(File file) {
        final ScriptEntry entry = this.scriptEntries.remove(file);
        if (entry == null) {
            return;
        }
        final RcpClientContext ctx = RcpClientContext.getInstance();
        if (ctx != null) {
            UIExecutor.sync(ctx.getDisplay(), new Runnable(){

                @Override
                public void run() {
                    if (entry.handler != null) {
                        ctx.getKeyAccelaratorManager().unregisterHandler(entry.handler);
                    }
                }
            });
        }
    }

    public List<GenericScriptHandler> getScriptHandlers(boolean includeUnlisted, boolean includeDeprecated) {
        ArrayList<GenericScriptHandler> r = new ArrayList<GenericScriptHandler>();
        for (ScriptEntry e : this.getEntries(includeUnlisted, includeDeprecated)) {
            if (e.handler == null) continue;
            r.add(e.handler);
        }
        return r;
    }

    public Collection<ScriptEntry> getEntries() {
        return Collections.unmodifiableCollection(this.scriptEntries.values());
    }

    public List<ScriptEntry> getEntries(boolean includeUnlisted, boolean includeDeprecated) {
        ArrayList<ScriptEntry> r = new ArrayList<ScriptEntry>();
        for (ScriptEntry e : Collections.unmodifiableCollection(this.scriptEntries.values())) {
            if (!includeUnlisted && e.getMetadata().isNolist() || !includeDeprecated && e.getMetadata().isDeprecated()) continue;
            r.add(e);
        }
        return r;
    }

    public List<ScriptEntry> getAutorunEntries(int wantedAutorunFlags) {
        ArrayList<ScriptEntry> r = new ArrayList<ScriptEntry>();
        for (ScriptEntry e : Collections.unmodifiableCollection(this.scriptEntries.values())) {
            if ((e.getMetadata().getAutorunFlags() & wantedAutorunFlags) != wantedAutorunFlags) continue;
            r.add(e);
        }
        r.sort(new Comparator<ScriptEntry>(){

            @Override
            public int compare(ScriptEntry a, ScriptEntry b) {
                return -Double.compare(a.getMetadata().getAutorunPriority(), b.getMetadata().getAutorunPriority());
            }
        });
        return r;
    }

    public String toString() {
        return Strings.ff("ScriptManager[folder=%s]", this.scriptsRootPath);
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                WatchKey key;
                try {
                    key = ScriptManager.this.watcher.take();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                Path dir = ScriptManager.this.wkmap.get(key);
                if (dir == null) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path filename;
                    File file;
                    if (Thread.interrupted()) return;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !(event.context() instanceof Path) || !(file = dir.resolve(filename = (Path)event.context()).toFile()).getName().endsWith(".py")) continue;
                    try {
                        ScriptManager.this.processFile(file, kind);
                    }
                    catch (Exception e) {
                        logger.catching(e);
                    }
                }
                boolean valid = key.reset();
                if (!valid) return;
            }
        }
    }
}

