/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.scripts;

import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.GenericScriptHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptMetadata;
import java.io.File;

public class ScriptEntry {
    File file;
    ScriptMetadata md;
    GenericScriptHandler handler;

    public ScriptEntry(File file, ScriptMetadata md) {
        if (file == null || !file.isFile() || !file.getName().endsWith(".py")) {
            throw new IllegalArgumentException("Illegal script file");
        }
        if (md == null) {
            throw new IllegalArgumentException("Missing metadata object");
        }
        this.file = file;
        this.md = md;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName().substring(0, this.file.getName().length() - 3);
    }

    public ScriptMetadata getMetadata() {
        return this.md;
    }

    public GenericScriptHandler getHandler() {
        return this.handler;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.md == null ? 0 : this.md.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptEntry other = (ScriptEntry)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return !(this.md == null ? other.md != null : !this.md.equals(other.md));
    }

    public String toString() {
        return "ScriptEntry [file=" + this.file + ", md=" + this.md + "]";
    }
}

