/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.scripts;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptEntry;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import org.eclipse.swt.widgets.Shell;

public class GenericScriptHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(GenericScriptHandler.class);
    public String name;
    public String path;

    public GenericScriptHandler(ScriptEntry entry) {
        super(null, entry.getName(), entry.getMetadata().getDescription(), null);
        this.name = entry.getName();
        this.path = entry.getFile().getAbsolutePath();
        int keycode = entry.getMetadata().getShortcutCode();
        if (keycode != 0) {
            this.setAccelerator(keycode);
        }
    }

    public GenericScriptHandler(String path) {
        super(null, new File(path).getName(), null, null);
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public void execute() {
        RcpClientContext context = RcpClientContext.getInstance();
        if (context == null) {
            throw new RuntimeException("The UI context cannot be retrieved");
        }
        Shell shell = context.getActiveShell();
        if (shell == null) {
            throw new RuntimeException("An active shell is required to run a script");
        }
        context.executeScript(shell, this.path);
    }
}

