/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.export;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileExportWriter;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.IFileExport;
import com.pnfsoftware.jeb.util.concurrent.DaemonExecutors;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FileExportDecompileAllJob<T extends ICodeItem>
implements IRunnableWithProgress {
    private static final ILogger logger = GlobalLog.getLogger(FileExportDecompileAllJob.class);
    public static int DEFAULT_ITEM_TIMEOUT_SECONDS = 120;
    private static final int TIME_BEFORE_CHECK_NEW_THREAD = 100;
    private RcpClientContext context;
    private IFileExport<T> fileExport;
    private Pattern pattern;
    private IDecompilerUnit decompiler;
    private FileExportWriter fileWriter;
    private int tryCount;

    public FileExportDecompileAllJob(RcpClientContext context, IFileExport<T> fileExport, Pattern pattern, IDecompilerUnit decompiler, FileExportWriter fileWriter, int itemTimeoutSeconds) {
        this.context = context;
        this.fileExport = fileExport;
        this.pattern = pattern;
        this.decompiler = decompiler;
        this.fileWriter = fileWriter;
        if (itemTimeoutSeconds < 0) {
            itemTimeoutSeconds = DEFAULT_ITEM_TIMEOUT_SECONDS;
        }
        this.tryCount = itemTimeoutSeconds * 1000 / 100;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int totalItems = 0;
        for (ICodeItem item : this.fileExport.getItems()) {
            if (!this.fileExport.canProcess(item)) continue;
            if (this.pattern == null) {
                ++totalItems;
                continue;
            }
            String fullName = this.fileExport.getFullName(item);
            if (fullName == null || !this.pattern.matcher(fullName).matches()) continue;
            ++totalItems;
        }
        logger.info("%d decompiled Code Item(s) will be saved", totalItems);
        monitor.beginTask("Exporting decompiled code", totalItems);
        ExecutorService pool = this.createExecutor();
        HashMap<String, Future<Boolean>> futures = new HashMap<String, Future<Boolean>>();
        block1: for (ICodeItem item : this.fileExport.getItems()) {
            List<String> packages = this.fileExport.getPath(item);
            if (!this.fileWriter.shouldGenerate(packages.toArray(new String[packages.size()]), item.getName(true))) {
                monitor.worked(1);
                continue;
            }
            if (!this.fileExport.canProcess(item)) continue;
            String fullNameWithPackage = this.fileExport.getFullName(item);
            if (this.pattern != null && (fullNameWithPackage == null || !this.pattern.matcher(fullNameWithPackage).matches())) continue;
            ExportJob job = new ExportJob(this, monitor, item, fullNameWithPackage);
            if (this.decompiler.getDecompiledUnit(item.getAddress()) != null) {
                job.call();
                continue;
            }
            this.submit(pool, futures, fullNameWithPackage, job);
            if (monitor.isCanceled()) {
                this.cancel(pool);
            }
            int i = 0;
            while (!this.canLaunchNewJob(pool, futures)) {
                pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
                if (monitor.isCanceled()) {
                    this.cancel(pool);
                }
                if (i > this.tryCount && this.tryCount > 0) {
                    pool = this.rebuildPool(pool, futures);
                    continue block1;
                }
                ++i;
            }
        }
        pool.shutdown();
        int i = 0;
        while (!pool.isTerminated() && !pool.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            if (monitor.isCanceled()) {
                this.cancel(pool);
            }
            if (i > this.tryCount && this.tryCount > 0) {
                this.rebuildPool(pool, futures);
                break;
            }
            ++i;
        }
    }

    private ExecutorService rebuildPool(ExecutorService pool, Map<String, Future<Boolean>> futures) throws InvocationTargetException {
        for (Map.Entry<String, Future<Boolean>> f : futures.entrySet()) {
            if (f.getValue().isDone()) continue;
            logger.error("Method %s can not be decompiled", f.getKey());
        }
        pool.shutdownNow();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        for (Map.Entry<String, Future<Boolean>> f : futures.entrySet()) {
            if (f.getValue().isDone()) continue;
            JebRuntimeException e = new JebRuntimeException(Strings.f("Export decompiled has been stopped because method %s takes too long.\nDecompilation is still pending.", f.getKey()));
            this.context.getErrorHandler().processThrowableSilent(e);
            throw new InvocationTargetException(e, e.getMessage());
        }
        futures.clear();
        pool = this.createExecutor();
        return pool;
    }

    private ExecutorService createExecutor() {
        return DaemonExecutors.newSingleThreadExecutor();
    }

    private int getActiveCount(ExecutorService pool) {
        if (pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)pool).getActiveCount();
        }
        return 1;
    }

    public boolean canLaunchNewJob(ExecutorService pool, Map<String, Future<Boolean>> futures) {
        int i = 0;
        for (Map.Entry<String, Future<Boolean>> f : futures.entrySet()) {
            if (f.getValue().isDone()) continue;
            ++i;
        }
        if (i == 0) {
            return true;
        }
        if (pool instanceof ThreadPoolExecutor) {
            int limit;
            int maxPoolSize = ((ThreadPoolExecutor)pool).getMaximumPoolSize();
            return i >= Math.min(maxPoolSize, limit = Runtime.getRuntime().availableProcessors());
        }
        return pool.isTerminated();
    }

    public void submit(ExecutorService pool, Map<String, Future<Boolean>> futures, String key, Callable<Boolean> task) {
        Future<Boolean> value = pool.submit(task);
        futures.put(key, value);
    }

    private void cancel(ExecutorService pool) throws InterruptedException {
        pool.shutdown();
        int activeOld = this.getActiveCount(pool);
        while (!pool.isTerminated()) {
            if (pool.awaitTermination(5L, TimeUnit.SECONDS)) continue;
            int activeNew = this.getActiveCount(pool);
            if (activeNew == activeOld) {
                pool.shutdownNow();
                break;
            }
            activeOld = activeNew;
        }
        throw new InterruptedException("Export decompiled code cancelled");
    }

    private static class ExportJob
    implements Callable<Boolean> {
        String fullNameWithPackage;
        IProgressMonitor monitor;
        T item;
        final /* synthetic */ FileExportDecompileAllJob this$0;

        public ExportJob(IProgressMonitor monitor, T item, String fullNameWithPackage) {
            this.this$0 = var1_1;
            this.fullNameWithPackage = fullNameWithPackage;
            this.monitor = monitor;
            this.item = item;
        }

        @Override
        public Boolean call() {
            long t0 = System.currentTimeMillis();
            logger.trace("Decompile %s", this.fullNameWithPackage);
            this.monitor.subTask("Decompiling " + this.fullNameWithPackage);
            ISourceUnit fileSourceUnit = null;
            List<String> p = this.this$0.fileExport.getPath(this.item);
            String[] packages = p.toArray(new String[p.size()]);
            String className = this.item.getName(true);
            boolean error = false;
            try {
                fileSourceUnit = this.this$0.decompiler.decompileToUnit(this.item.getAddress());
                if (fileSourceUnit == null) {
                    logger.warn("Unable to decompile %s", this.fullNameWithPackage);
                }
            }
            catch (Exception e) {
                logger.error("An error occurred: cannot decompile %s", this.fullNameWithPackage);
                logger.catchingSilent(e);
                error = true;
            }
            if (error || fileSourceUnit == null) {
                try {
                    this.this$0.fileWriter.writeSourceFile((ICodeItem)this.item, packages, className);
                }
                catch (IOException e1) {
                    logger.catchingSilent(e1);
                }
                return false;
            }
            long t1 = System.currentTimeMillis();
            logger.trace("Decompiled %s in %d ms", this.fullNameWithPackage, t1 - t0);
            this.monitor.subTask("Saving " + this.fullNameWithPackage);
            try {
                this.this$0.fileWriter.writeFile(fileSourceUnit, packages, className);
            }
            catch (IOException e) {
                logger.error("An IO error occurred: cannot write %s", this.fullNameWithPackage);
                logger.catchingSilent(e);
                return false;
            }
            long t2 = System.currentTimeMillis();
            logger.trace("Wrote %s in %d ms", this.fullNameWithPackage, t2 - t1);
            FileExportDecompileAllJob fileExportDecompileAllJob = this.this$0;
            synchronized (fileExportDecompileAllJob) {
                this.monitor.worked(1);
            }
            return true;
        }
    }
}

