/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file.export;

import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.IFileExport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileExportCodeMethod
implements IFileExport<INativeMethodItem> {
    private List<? extends INativeMethodItem> allMethods;

    public FileExportCodeMethod(List<? extends INativeMethodItem> allMethods) {
        this.allMethods = allMethods;
    }

    @Override
    public List<? extends INativeMethodItem> getItems() {
        return this.allMethods;
    }

    @Override
    public boolean canProcess(INativeMethodItem item) {
        return true;
    }

    @Override
    public List<String> getPath(INativeMethodItem item) {
        String address = item.getAddress();
        if (!address.contains("::")) {
            return new ArrayList<String>();
        }
        String[] fullName = address.split("::");
        ArrayList<String> fullPath = new ArrayList<String>(Arrays.asList(fullName));
        fullPath.remove(fullPath.size() - 1);
        return fullPath;
    }

    @Override
    public String getFullName(INativeMethodItem item) {
        return item.getAddress();
    }

    @Override
    public boolean isAtAddress(INativeMethodItem item, String address) {
        String itemAddress = item.getAddress();
        if (address.equals(itemAddress)) {
            return true;
        }
        return itemAddress.startsWith(address + "::");
    }

    @Override
    public String getNameFromSourceUnit(ISourceUnit sourceUnit) {
        return sourceUnit.getName();
    }
}

