/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ScriptSelectorDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileScriptsExecuteHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileScriptsExecuteHandler.class);

    public FileScriptsExecuteHandler() {
        super("runScript", "Script selector...", 0, null, null, 0x100000B);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null;
    }

    @Override
    public void execute() {
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        String path = FileScriptsExecuteHandler.select(this.getShell(), this.context);
        if (path == null) {
            return;
        }
        this.context.executeScript(this.getShell(), path);
    }

    static String select(Shell shell, RcpClientContext context) {
        ScriptSelectorDialog dlg = JebDialog.getInstance(ScriptSelectorDialog.class);
        if (dlg != null) {
            dlg.setFocus();
            return null;
        }
        dlg = new ScriptSelectorDialog(shell, context);
        if (dlg.open() >= 0) {
            return dlg.getSelectedEntry();
        }
        return null;
    }

    static String askForScriptPath(Shell shell, RcpClientContext context) {
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setText(S.s(318));
        dlg.setFilterExtensions(new String[]{"*.py", "*.*"});
        dlg.setFilterNames(new String[]{S.s(674) + " (*.py)", S.s(55) + " (*.*)"});
        try {
            String defaultDir = context.getDefaultPathForDialog("dlgJebFileExecuteScript");
            if (defaultDir == null || !new File(defaultDir).exists()) {
                defaultDir = new File(context.getScriptsDirectory()).getAbsolutePath();
            }
            dlg.setFilterPath(defaultDir);
        }
        catch (Exception exception) {}
        String path = dlg.open();
        if (path != null) {
            String newDefaultDir = new File(path).getParent();
            context.setDefaultPathForDialog("dlgJebFileExecuteScript", newDefaultDir);
        }
        return path;
    }
}

