/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.dialogs.other.S7BlkAcqDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileOpenHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class FileOpenSimaticS7Handler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileOpenHandler.class);

    public FileOpenSimaticS7Handler() {
        super(null, "Acquire Simatic S7 blocks...", "Acquire and create a project consisting of Simatic S7 PLC blocks", "images/s7_icon.png");
    }

    @Override
    public boolean canExecute() {
        if (!Licensing.hasDecompS7) {
            return false;
        }
        return this.hasValidShell();
    }

    @Override
    public void execute() {
        if (!Licensing.hasDecompS7) {
            return;
        }
        S7BlkAcqDialog dlg = new S7BlkAcqDialog(this.getShell(), this.context);
        dlg.open();
        String path = dlg.getFilePath();
        if (path != null) {
            this.context.getTelemetry().record("handlerOpenS7");
            this.context.loadInputAsProject(this.getShell(), path);
        }
    }
}

