/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.dialogs.ethereum.EthereumContractDownloaderDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileOpenHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class FileOpenContractHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileOpenHandler.class);

    public FileOpenContractHandler() {
        super(null, "Download Ethereum contract...", "Open or download an Ethereum smart contract", "images/ethereum_icon.png");
    }

    @Override
    public boolean canExecute() {
        if (!Licensing.hasDecompEvm) {
            return false;
        }
        return this.hasValidShell();
    }

    @Override
    public void execute() {
        if (!Licensing.hasDecompEvm) {
            return;
        }
        EthereumContractDownloaderDialog dlg = new EthereumContractDownloaderDialog(this.getShell(), this.context);
        dlg.open();
        String path = dlg.getFilePath();
        if (path != null) {
            this.context.getTelemetry().record("handlerOpenContract", "downloaded", dlg.isDownloaded() ? "1" : "0");
            this.context.loadInputAsProject(this.getShell(), path);
        }
    }
}

