/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.swt.widgets.Shell;

public class FileExportWriter {
    private static final ILogger logger = GlobalLog.getLogger(FileExportWriter.class);
    private static final int MAX_BUFFER_SIZE = 16384;
    private Shell shell;
    private String outputDirectory;
    private String filename;
    private boolean mergeFiles;
    private boolean filesAlreadyProcessed;
    private boolean shouldResume;
    int overwrite = -1;

    public FileExportWriter(Shell shell, String outputDirectory, String filename, boolean mergeFiles, boolean shouldResume) {
        this.shell = shell;
        this.outputDirectory = outputDirectory;
        this.filename = filename;
        this.mergeFiles = mergeFiles;
        this.shouldResume = shouldResume;
        if (mergeFiles && shouldResume) {
            throw new IllegalArgumentException("Uncompatible options");
        }
    }

    private Path getTargetDirectory(String[] packages) {
        if (this.mergeFiles) {
            return Paths.get(this.outputDirectory, new String[0]);
        }
        return Paths.get(this.outputDirectory, packages);
    }

    private Path getTargetDirectory(String[] packages, boolean createIfNotExist) throws IOException {
        Path dir = this.getTargetDirectory(packages);
        File dirFile = dir.toFile();
        if (dirFile.exists() && !dirFile.isDirectory() || !dirFile.exists() && !dirFile.mkdirs()) {
            throw new IOException("Can not create directory " + dir);
        }
        return dir;
    }

    public Path getTargetFile(ISourceUnit fileSourceUnit, String[] packages, String className) {
        return this.getTargetFileInner(fileSourceUnit.getFileExtension(), this.getTargetDirectory(packages), className);
    }

    private Path getTargetFileInner(String extension, Path dir, String className) {
        if (this.mergeFiles) {
            return dir.resolve(this.filename);
        }
        Object name = className;
        if (extension != null) {
            name = (String)name + "." + extension;
        }
        return dir.resolve((String)name);
    }

    public boolean shouldGenerate(String[] packages, String className) {
        if (!this.shouldResume) {
            return true;
        }
        Path dir = this.getTargetDirectory(packages);
        Path target = this.getTargetFileInner(null, dir, className);
        File t = target.toFile();
        String[] candidates = t.getParentFile().list(new FileNameFilterExp(t.getName()));
        return candidates == null || candidates.length == 0;
    }

    public void writeFile(ISourceUnit fileSourceUnit, String[] packages, String className) throws IOException {
        Path dir = this.getTargetDirectory(packages, true);
        Path file = this.getTargetFileInner(fileSourceUnit.getFileExtension(), dir, className);
        StandardOpenOption[] options = this.prepareOptions(file);
        if (options != null) {
            this.writeFile(file, FileExportWriter.getTextDocument(fileSourceUnit), options);
        }
    }

    public void writeSourceFile(ICodeItem codeItem, String[] packages, String className) throws IOException {
        Path dir = this.getTargetDirectory(packages, true);
        Path file = this.getTargetFileInner("err", dir, className);
        OpenOption[] options = this.prepareOptions(file);
        if (options != null) {
            String result = "";
            if (codeItem instanceof INativeMethodItem) {
                INativeMethodDataItem data = ((INativeMethodItem)codeItem).getData();
                if (data != null) {
                    CFG<? extends IInstruction> cfg = data.getCFG();
                    result = cfg == null ? "" : cfg.format();
                }
            } else {
                result = "";
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, Charset.forName("UTF-8"), options);){
                writer.write(result);
            }
        }
    }

    private StandardOpenOption[] prepareOptions(Path file) {
        StandardOpenOption[] options = new StandardOpenOption[]{StandardOpenOption.APPEND};
        if (this.overwrite == 0 && file.toFile().exists()) {
            return null;
        }
        if (!this.mergeFiles || !this.filesAlreadyProcessed) {
            this.filesAlreadyProcessed = true;
            if (file.toFile().exists() && this.overwrite < 0) {
                OverwritePopup pu = new OverwritePopup(file.toFile());
                UIExecutor.sync(this.shell.getDisplay(), (Runnable)pu);
                if (this.overwrite == 0) {
                    this.resetOverwrite(pu.doNotShow);
                    return null;
                }
                this.resetOverwrite(pu.doNotShow);
            }
            options = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            logger.info("Writing to %s", file);
        }
        return options;
    }

    private void resetOverwrite(boolean doNotShow) {
        if (!doNotShow) {
            this.overwrite = -1;
        }
    }

    private synchronized void writeFile(Path f, ITextDocument textDocument, StandardOpenOption[] options) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(f, Charset.forName("UTF-8"), (OpenOption[])options);){
            long i;
            long end = i + textDocument.getAnchorCount();
            for (i = textDocument.getFirstAnchor(); i < end; ++i) {
                List<? extends ILine> lines = textDocument.getDocumentPart(i, 0).getLines();
                for (ILine iLine : lines) {
                    CharSequence s = iLine.getText();
                    if (s.length() > 16384) {
                        for (int offset = 0; offset < s.length(); offset += 16384) {
                            writer.write(s.subSequence(offset, Math.min(s.length(), offset + 16384)).toString());
                        }
                    } else {
                        writer.write(s.toString());
                    }
                    writer.newLine();
                }
            }
            if (this.mergeFiles) {
                writer.newLine();
            }
        }
    }

    private static ITextDocument getTextDocument(ISourceUnit sourceUnit) {
        IGenericDocument genericDoc;
        IUnitFormatter formatter = sourceUnit.getFormatter();
        if (formatter != null && CollectionUtils.isNotEmpty(formatter.getPresentations()) && (genericDoc = formatter.getPresentations().get(0).getDocument()) != null) {
            if (genericDoc instanceof ITextDocument) {
                return (ITextDocument)genericDoc;
            }
            genericDoc.dispose();
        }
        return null;
    }

    private static class FileNameFilterExp
    implements FilenameFilter {
        private String baseName;

        public FileNameFilterExp(String baseName) {
            this.baseName = baseName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.baseName.equals(name) || name.startsWith(this.baseName + ".");
        }
    }

    class OverwritePopup
    implements Runnable {
        File file;
        boolean doNotShow = false;

        public OverwritePopup(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            String msg = Strings.f("File %s already exists.\nDo you want to overwrite?", this.file);
            AdaptivePopupDialog popup = AdaptivePopupDialog.question(FileExportWriter.this.shell, "Overwrite File?", msg);
            FileExportWriter.this.overwrite = popup.open();
            this.doNotShow = popup.isDoNotShow();
        }
    }
}

