/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPackage;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPackage;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.dialogs.ExportDecompiledCodeDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ProgressMonitorHideableDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileExportWriter;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.FileExportDecompileAllJob;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.FileExportDecompiledDecompJob;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.FileExportFactory;
import com.pnfsoftware.jeb.rcpclient.handlers.file.export.IFileExport;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectExplorerPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FileExportDecompiledCodeHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileExportDecompiledCodeHandler.class);
    static String[] charactersToEscape = new String[]{"<", ">", "(", ")", "[", "]", "{", "}", "\\", "^", "$", ".", "-", "=", "!", "|", "?", "*", "+"};
    private static ProgressMonitorHideableDialog progressBar = null;

    public FileExportDecompiledCodeHandler() {
        super(null, S.s(476), null, null);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        IMPartManager object = this.part.getManager();
        if (object instanceof UnitPartManager) {
            IUnit unit = ((UnitPartManager)object).getUnit();
            return FileExportDecompiledCodeHandler.isDecompilable(unit);
        }
        if (object instanceof ProjectExplorerPartManager) {
            Object unit = ((ProjectExplorerPartManager)object).getSelectedNode();
            return FileExportDecompiledCodeHandler.isDecompilable(unit);
        }
        return false;
    }

    private static boolean isDecompilable(Object unit) {
        return unit instanceof ICodeUnit || unit instanceof ISourceUnit || unit instanceof IDecompilerUnit;
    }

    @Override
    public void execute() {
        IRunnableWithProgress runnable;
        Object potentialUnit;
        if (Licensing.isDemoBuild()) {
            MessageDialog.openWarning(this.getShell(), S.s(249), S.s(265));
            return;
        }
        if (progressBar != null && progressBar.isAlive()) {
            progressBar.setVisible(true);
            return;
        }
        IMPartManager object = this.part.getManager();
        UnitPartManager unitPart = null;
        IUnit unit = null;
        if (object instanceof UnitPartManager) {
            unitPart = (UnitPartManager)object;
            unit = unitPart.getUnit();
        } else if (object instanceof ProjectExplorerPartManager && FileExportDecompiledCodeHandler.isDecompilable(potentialUnit = ((ProjectExplorerPartManager)object).getSelectedNode())) {
            unit = (IUnit)potentialUnit;
        }
        if (unit == null) {
            return;
        }
        ISourceUnit sourceUnit = null;
        ICodeUnit code = null;
        IDecompilerUnit decomp = null;
        if (unit instanceof ISourceUnit) {
            sourceUnit = (ISourceUnit)unit;
            parent = unit.getParent();
            if (!(parent instanceof IDecompilerUnit)) {
                return;
            }
            decomp = (IDecompilerUnit)parent;
            if (!((parent = decomp.getParent()) instanceof IUnit)) {
                return;
            }
            code = (ICodeUnit)parent;
        } else if (unit instanceof ICodeUnit) {
            code = (ICodeUnit)unit;
            decomp = DecompilerHelper.getDecompiler(code);
            if (decomp == null) {
                logger.warn("No decompiler available: cannot export", new Object[0]);
                if (!(unit.getParent() instanceof IUnit) || !((IUnit)unit.getParent()).getName().equals("decompiler")) {
                    return;
                }
            }
        } else if (unit instanceof IDecompilerUnit) {
            decomp = (IDecompilerUnit)unit;
            parent = decomp.getParent();
            if (!(parent instanceof IUnit)) {
                return;
            }
            code = (ICodeUnit)parent;
        }
        if (code == null || decomp == null || !decomp.isProcessed() && !decomp.process()) {
            logger.warn("The decompiler is not ready!", new Object[0]);
            return;
        }
        IFileExport<? extends ICodeItem> fileExport = FileExportFactory.get(code);
        if (fileExport == null) {
            MessageDialog.openError(this.getShell(), "No methods or classes found", "There are no methods nor classes defined for this unit");
            return;
        }
        ExportDecompiledCodeDialog.ExportStatus initialStatus = FileExportDecompiledCodeHandler.getDefaultFilter(unitPart, fileExport, sourceUnit);
        ExportDecompiledCodeDialog dlg = new ExportDecompiledCodeDialog(this.getShell());
        dlg.setInitialState(initialStatus);
        dlg.setInitialDirectory(this.context.getCurrentDirectory());
        dlg.setInitialItemTimeoutSec(FileExportDecompileAllJob.DEFAULT_ITEM_TIMEOUT_SECONDS);
        ExportDecompiledCodeDialog.ExportStatus responseStatus = dlg.open();
        if (responseStatus == null) {
            return;
        }
        int itemTimeout = dlg.getItemTimeoutSec();
        FileExportWriter fileWriter = new FileExportWriter(this.getShell(), dlg.getOutputDirectory(), dlg.getOutputFile(), dlg.isMergeFiles(), dlg.shoudResume());
        Pattern pattern = null;
        if (responseStatus.getState() == ExportDecompiledCodeDialog.State.FILTER && !Strings.isBlank(responseStatus.getFilter())) {
            pattern = Pattern.compile(responseStatus.getFilter());
        } else if (responseStatus.getState() == ExportDecompiledCodeDialog.State.CURRENT) {
            pattern = Pattern.compile(initialStatus.getFilter());
        }
        progressBar = new ProgressMonitorHideableDialog(this.getShell());
        if (responseStatus.getState() == ExportDecompiledCodeDialog.State.DECOMPILED) {
            List<? extends IUnit> sourceUnits = decomp.getChildren();
            runnable = new FileExportDecompiledDecompJob(fileExport, sourceUnits, fileWriter);
        } else {
            runnable = new FileExportDecompileAllJob<ICodeItem>(this.context, fileExport, pattern, decomp, fileWriter, itemTimeout);
        }
        PartManager pman = this.context.getPartManager();
        pman.setRedraw(code, false);
        try {
            progressBar.run(true, true, runnable);
            UI.info(this.getShell(), "Export successful", "Decompiled files can be found in " + dlg.getOutputDirectory() + (String)(dlg.isMergeFiles() ? File.separator + dlg.getOutputFile() : ""));
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), new Object[0]);
            return;
        }
        catch (InvocationTargetException e) {
            UI.error(this.getShell(), "Export failed", e.getMessage());
            logger.catching(e);
        }
        finally {
            pman.setRedraw(code, true);
        }
    }

    private static <T> ExportDecompiledCodeDialog.ExportStatus getDefaultFilter(UnitPartManager unitPart, IFileExport<T> fileExport, ISourceUnit sourceUnit) {
        ICodeItem obj;
        if (sourceUnit != null) {
            return new ExportDecompiledCodeDialog.ExportStatus(ExportDecompiledCodeDialog.State.CURRENT, fileExport.getNameFromSourceUnit(sourceUnit));
        }
        Object filter = null;
        if (unitPart == null) {
            return new ExportDecompiledCodeDialog.ExportStatus(ExportDecompiledCodeDialog.State.ALL, (String)filter);
        }
        IItem item = unitPart.getActiveItem();
        if (item instanceof ICodeNode && (obj = ((ICodeNode)item).getObject()) instanceof ICodePackage) {
            filter = obj instanceof IDexPackage ? FileExportDecompiledCodeHandler.escape(FileExportDecompiledCodeHandler.getFullPath((ICodeNode)item)) + "\\..*" : (obj instanceof IPackage ? FileExportDecompiledCodeHandler.escape(FileExportDecompiledCodeHandler.getFullPath((ICodeNode)item)) + "::.*" : FileExportDecompiledCodeHandler.escape(FileExportDecompiledCodeHandler.getFullPath((ICodeNode)item)) + ".*");
            return new ExportDecompiledCodeDialog.ExportStatus(ExportDecompiledCodeDialog.State.ALL, (String)filter);
        }
        String address = unitPart.getActiveAddress();
        if (address != null) {
            for (T c : fileExport.getItems()) {
                if (!fileExport.canProcess(c) || !fileExport.isAtAddress(c, address)) continue;
                filter = FileExportDecompiledCodeHandler.escape(fileExport.getFullName(c));
                break;
            }
        } else if (item instanceof ICodeNode) {
            filter = FileExportDecompiledCodeHandler.escape(FileExportDecompiledCodeHandler.getFullPath((ICodeNode)item)) + ".*";
        }
        return new ExportDecompiledCodeDialog.ExportStatus(ExportDecompiledCodeDialog.State.ALL, (String)filter);
    }

    private static String escape(String s) {
        if (Strings.contains(s, charactersToEscape)) {
            return Pattern.quote(s);
        }
        return s;
    }

    private static String getFullPath(ICodeNode p) {
        ArrayList<String> packages = new ArrayList<String>();
        while (p != null) {
            if (p.getLabel() != null) {
                packages.add(0, p.getLabel());
            }
            p = p.getParent();
        }
        return StringUtils.join(packages, (char)'.');
    }
}

