/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.CodeUtil;
import com.pnfsoftware.jeb.core.units.code.DecompilationContext;
import com.pnfsoftware.jeb.core.units.code.DecompilationOptions;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.dialogs.ExportDecompiledCodeDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectExplorerPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.base.CallableWithProgressCallback;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;

public class FileExportDecompilationHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileExportDecompilationHandler.class);

    public FileExportDecompilationHandler() {
        super(null, "Decompilation...", null, null);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        IMPartManager object = this.part.getManager();
        if (object instanceof UnitPartManager) {
            IUnit unit = ((UnitPartManager)object).getUnit();
            return FileExportDecompilationHandler.isDecompilable(unit);
        }
        if (object instanceof ProjectExplorerPartManager) {
            Object unit = ((ProjectExplorerPartManager)object).getSelectedNode();
            return FileExportDecompilationHandler.isDecompilable(unit);
        }
        return false;
    }

    private static boolean isDecompilable(Object unit) {
        return unit instanceof ICodeUnit || unit instanceof IDecompilerUnit || unit instanceof ISourceUnit;
    }

    @Override
    public void execute() {
        Object potentialUnit;
        if (Licensing.isDemoBuild()) {
            MessageDialog.openWarning(this.getShell(), S.s(249), S.s(265));
            return;
        }
        IMPartManager object = this.part.getManager();
        IUnit unit = null;
        if (object instanceof UnitPartManager) {
            UnitPartManager unitPart = (UnitPartManager)object;
            unit = unitPart.getUnit();
        } else if (object instanceof ProjectExplorerPartManager && FileExportDecompilationHandler.isDecompilable(potentialUnit = ((ProjectExplorerPartManager)object).getSelectedNode())) {
            unit = (IUnit)potentialUnit;
        }
        if (unit == null) {
            return;
        }
        ICodeUnit code = null;
        IDecompilerUnit decomp = null;
        if (unit instanceof ISourceUnit) {
            parent = unit.getParent();
            if (!(parent instanceof IDecompilerUnit)) {
                return;
            }
            decomp = (IDecompilerUnit)parent;
            if (!((parent = decomp.getParent()) instanceof IUnit)) {
                return;
            }
            code = (ICodeUnit)parent;
        } else if (unit instanceof ICodeUnit) {
            code = (ICodeUnit)unit;
            decomp = DecompilerHelper.getDecompiler(code);
        } else if (unit instanceof IDecompilerUnit) {
            decomp = (IDecompilerUnit)unit;
            parent = decomp.getParent();
            if (!(parent instanceof ICodeUnit)) {
                return;
            }
            code = (ICodeUnit)parent;
        }
        if (code == null || decomp == null || !decomp.isProcessed() && !decomp.process()) {
            logger.warn("The decompiler is not ready!", new Object[0]);
            return;
        }
        ExportDecompiledCodeDialog.ExportStatus initialStatus = new ExportDecompiledCodeDialog.ExportStatus(ExportDecompiledCodeDialog.State.ALL, null);
        ExportDecompiledCodeDialog dlg = new ExportDecompiledCodeDialog(this.getShell(), "Fast Decompilation & Export");
        dlg.optAllow_OnlyDecompiledItems = null;
        dlg.optAllow_CurrentSourceUnit = null;
        dlg.optAllow_MergeAll = null;
        dlg.optAllow_Resume = null;
        dlg.setInitialState(initialStatus);
        dlg.setInitialDirectory(this.context.getCurrentDirectory());
        dlg.setInitialItemTimeoutSec(60);
        dlg.setInitialTotalTimeoutSec(600);
        ExportDecompiledCodeDialog.ExportStatus responseStatus = dlg.open();
        if (responseStatus == null) {
            return;
        }
        final int itemTimeout = dlg.getItemTimeoutSec();
        final int totalTimeout = dlg.getTotalTimeoutSec();
        Pattern pattern = null;
        if (responseStatus.getState() == ExportDecompiledCodeDialog.State.FILTER && !Strings.isBlank(responseStatus.getFilter())) {
            pattern = Pattern.compile(responseStatus.getFilter());
        }
        final ArrayList addresses = new ArrayList();
        boolean isDalvik = decomp instanceof IDexDecompilerUnit;
        if (isDalvik) {
            List<ICodeClass> classes = CodeUtil.collectClasses(decomp.getCodeUnit(), true, true, pattern);
            classes.forEach(c -> addresses.add(c.getAddress()));
        } else {
            List<ICodeMethod> methods = CodeUtil.collectMethods(decomp.getCodeUnit(), true, true, pattern);
            methods.forEach(m -> addresses.add(m.getAddress()));
            List<ICodeClass> classes = CodeUtil.collectClasses(decomp.getCodeUnit(), true, true, pattern);
            classes.forEach(c -> addresses.add(c.getAddress()));
        }
        final IDecompilerUnit _decomp = decomp;
        String taskName = Strings.ff("%s...", S.s(246));
        Couple<Boolean, DecompilationContext> r = this.context.executeTaskWithPopupDelay(100, taskName, false, new CallableWithProgressCallback<Couple<Boolean, DecompilationContext>>(){

            @Override
            public Couple<Boolean, DecompilationContext> call() {
                DecompilationOptions.Builder optbld = DecompilationOptions.Builder.newInstance();
                if (itemTimeout > 0) {
                    optbld.maxTimePerMethod((long)itemTimeout * 1000L);
                }
                if (totalTimeout > 0) {
                    optbld.maxTimeTotal((long)totalTimeout * 1000L);
                }
                DecompilationContext ctx = new DecompilationContext(optbld.build());
                ctx.setCallback(this.callback);
                boolean success = _decomp.decompile(addresses, ctx);
                return new Couple<Boolean, DecompilationContext>(success, ctx);
            }
        });
        boolean success = r != null && r.getFirst() != false;
        UI.info(this.getShell(), "Export (step 1/2)", "Decompilation completed." + (success ? "" : " Errors occurred (see log)."));
        File outdir = new File(dlg.getOutputDirectory());
        String ext = decomp.getOutputType().getPreferredExtension();
        int cntfiles = 0;
        for (String addr : addresses) {
            ISourceUnit srcunit = decomp.getDecompiledUnit(addr);
            String text = srcunit != null ? srcunit.getSourceDocument().format() : decomp.getDecompiledText(addr);
            if (text == null) continue;
            Object subpath = isDalvik ? addr.substring(1, addr.length() - 1) : addr.replace("::", "/");
            subpath = IO.sanitizePath((String)subpath, false, false);
            subpath = (String)subpath + ext;
            File file = new File(outdir, (String)subpath);
            try {
                IO.writeFile(file, Strings.encodeLocal(text), true);
                ++cntfiles;
            }
            catch (IOException iOException) {}
        }
        UI.info(this.getShell(), "Export (step 2/2)", cntfiles + " files were written.");
        decomp.runGarbageCollection();
    }
}

