/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.WellKnownUnitTypes;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;

public class FileExportAllBinaryUnitsHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileExportAllBinaryUnitsHandler.class);

    public FileExportAllBinaryUnitsHandler() {
        super(null, "All Binary Units...", null, null);
    }

    @Override
    public boolean canExecute() {
        IRuntimeProject prj = this.context.getOpenedProject();
        return prj != null && prj.getLiveArtifacts() != null;
    }

    @Override
    public void execute() {
        if (Licensing.isDemoBuild()) {
            MessageDialog.openWarning(this.getShell(), S.s(249), S.s(265));
            return;
        }
        IRuntimeProject prj = this.context.getOpenedProject();
        DirectoryDialog dlg = new DirectoryDialog(this.getShell(), 8192);
        dlg.setText(S.s(340));
        String filepath = dlg.open();
        if (filepath == null) {
            return;
        }
        Object[] objectArray = new Object[]{S.s(340), filepath};
        File path = new File(filepath);
        List<ILiveArtifact> artifacts = prj.getLiveArtifacts();
        try {
            for (ILiveArtifact art : artifacts) {
                String dirName = IO.escapeFileName(art.getArtifact().getName());
                int dotIndex = dirName.lastIndexOf(46);
                if (dotIndex != -1) {
                    dirName = dirName.substring(0, dotIndex);
                }
                this.processUnits(art.getUnits(), new File(path, dirName + "-export"));
            }
        }
        catch (JebException e) {
            MessageDialog.openError(this.getShell(), "Can not export binaries", e.getMessage());
            return;
        }
        UI.info(this.getShell(), "Export successful", "Binary files can be found in " + filepath + File.separator + "${artifactName}-export");
    }

    private void processUnits(List<? extends IUnit> units, File initPath) throws JebException {
        File path = this.getNewPathName(initPath, "_", true);
        if (units != null) {
            for (IUnit iUnit : units) {
                String subDir = IO.escapeFileName(iUnit.getName());
                if (iUnit instanceof IBinaryUnit) {
                    try {
                        Object fileName = subDir;
                        if (!((String)fileName).contains(".") || iUnit.getChildren() != null && iUnit.getChildren().size() > 0) {
                            String extension = "." + WellKnownUnitTypes.toCommonExtension(iUnit.getFormatType());
                            if (!extension.isEmpty() && ((String)fileName).endsWith(extension)) {
                                subDir = subDir.substring(0, subDir.length() - extension.length());
                            } else {
                                fileName = (String)fileName + IO.escapeFileName(extension);
                            }
                        }
                        if (!path.exists() && !path.mkdirs()) {
                            path = new File(initPath.getParentFile(), IO.escapeFileNameStrict(initPath.getName()));
                            if (!(path = this.getNewPathName(path, "_", true)).exists() && !path.mkdirs()) {
                                throw new JebException("Can not write to directory " + path);
                            }
                        }
                        File target = new File(path, (String)fileName);
                        if (!(target = this.getNewPathName(target, ".", false)).createNewFile()) {
                            target = new File(path, IO.escapeFileNameStrict((String)fileName));
                            if (!(target = this.getNewPathName(target, ".", false)).createNewFile()) {
                                throw new JebException("Can not write to directory " + path);
                            }
                        }
                        FileUtils.copyInputStreamToFile((InputStream)((IBinaryUnit)iUnit).getInput().getStream(), (File)target);
                    }
                    catch (IOException e) {
                        logger.catching(e);
                    }
                }
                this.processUnits(iUnit.getChildren(), new File(path, subDir));
            }
        }
    }

    private File getNewPathName(File path, String separator, boolean checkDirectory) {
        int i = 0;
        while (!(!path.exists() || checkDirectory && path.isDirectory())) {
            path = new File(path.getParentFile(), path.getName() + separator + i);
            ++i;
        }
        return path;
    }
}

