/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.ProgressMonitorHideableDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.file.FileExportActiveViewHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;

public class FileExportActiveViewAsHtmlHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(FileExportActiveViewAsHtmlHandler.class);
    private static ProgressMonitorHideableDialog progressBar = null;

    public FileExportActiveViewAsHtmlHandler() {
        super(null, "Active View as HTML...", null, null);
    }

    @Override
    public boolean canExecute() {
        return FileExportActiveViewHandler.canExport(this.getActiveFragment());
    }

    @Override
    public void execute() {
        if (Licensing.isDemoBuild()) {
            MessageDialog.openWarning(this.getShell(), S.s(249), S.s(265));
            return;
        }
        if (progressBar != null && progressBar.isAlive()) {
            progressBar.setVisible(true);
            return;
        }
        AbstractUnitFragment<?> fragment = this.getActiveFragment();
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setText(S.s(339));
        dlg.setOverwrite(true);
        UnitPartManager pman = this.context.getPartManager().getUnitPartManager(this.part);
        dlg.setFileName(FileExportActiveViewHandler.getDefaultFilename(pman, ".html"));
        String filepath = dlg.open();
        if (filepath == null) {
            return;
        }
        Object[] objectArray = new Object[]{S.s(340), filepath};
        String s = fragment.exportAsText(true);
        byte[] content = s != null ? Strings.encodeLocal(s) : fragment.export();
        if (content != null) {
            try {
                IO.writeFile(new File(filepath), content);
                UI.info(this.getShell(), "Export successful", "Exported file: " + filepath);
            }
            catch (IOException e) {
                logger.catching(e);
                UI.error(this.getShell(), "Export failed", "Can not write file " + filepath);
            }
        } else {
            UI.error(this.getShell(), "Export not supported", "Export is not supported for the current view.");
        }
    }
}

