/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.file;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class FileDecompListHandler
extends JebBaseHandler {
    private final Collection<String> existingDecomps = Arrays.asList("dex", "x86", "x86_64", "arm", "arm64", "mips", "mips64", "riscv", "simatic_mc7", "wasmbc", "evmbc", "avr");

    public FileDecompListHandler() {
        super(null, "Decompilers...", null, null);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null;
    }

    @Override
    public void execute() {
        StringBuilder sb = new StringBuilder();
        Strings.ff(sb, "Decompilers available with your %s build:\n", Licensing.buildkey);
        HashSet<String> availableDecomps = new HashSet<String>();
        int i = 0;
        for (IUnitIdentifier iUnitIdentifier : this.context.getEnginesContext().getUnitIdentifiers()) {
            String type = iUnitIdentifier.getFormatType();
            if (type == null || !type.startsWith("dcmp_")) continue;
            String decomp = type.substring("dcmp_".length());
            availableDecomps.add(decomp);
            if (i >= 1) {
                sb.append("\n");
            }
            Strings.ff(sb, "- %s (%s)", decomp, iUnitIdentifier.getPluginInformation().getName());
            ++i;
        }
        if (i == 0) {
            Strings.ff(sb, "No decompiler available!", new Object[0]);
        }
        LinkedHashSet<String> decomps = new LinkedHashSet<String>(this.existingDecomps);
        decomps.removeAll(availableDecomps);
        if (!decomps.isEmpty()) {
            Strings.ff(sb, "\n\nDecompilers available in other builds:\n", new Object[0]);
            i = 0;
            for (String decomp : decomps) {
                if (i >= 1) {
                    sb.append("\n");
                }
                Strings.ff(sb, "- %s", decomp);
                ++i;
            }
        }
        String string = sb.toString();
        UI.info(this.getShell(), "Decompilers", string);
    }
}

