/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import java.util.List;

public class DebuggerSetBreakpointOnFieldReadHandler
extends DebuggerBaseHandler {
    public DebuggerSetBreakpointOnFieldReadHandler() {
        super("dbgSetBreakpointOnFieldRead", "Break on field read (access)", null, null, 0);
    }

    @Override
    public boolean canExecute() {
        String address;
        IUnit unit = this.getActiveUnit();
        if (unit instanceof ICodeUnit && (address = DebuggerSetBreakpointOnFieldReadHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE).getAddress()) != null) {
            ICodeItem item = ((ICodeUnit)unit).getCodeItemByAddress(address);
            return item instanceof ICodeField;
        }
        return false;
    }

    @Override
    public void execute() {
        ICodeUnit unit = (ICodeUnit)this.getActiveUnit();
        String address = DebuggerSetBreakpointOnFieldReadHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE).getAddress();
        IRuntimeProject prj = this.context.getOpenedProject();
        List<IDebuggerUnit> debuggers = RuntimeProjectUtil.findUnitsByType(prj, IDebuggerUnit.class, false);
        for (IDebuggerUnit dbg : debuggers) {
            if (!dbg.getPotentialDebuggees().contains(unit) || !dbg.isAttached()) continue;
            IDebuggerBreakpoint bp = dbg.getBreakpoint(address, unit);
            if (bp != null) {
                if (bp.getFlags() == 1) {
                    return;
                }
                dbg.clearBreakpoint(bp);
            }
            dbg.setBreakpoint(address, unit, 1);
            return;
        }
        UIState uiState = this.context.getUIState(unit);
        if (!uiState.isBreakpoint(address)) {
            uiState.setBreakpoint(address, true);
        } else {
            uiState.removeBreakpoint(address);
        }
    }
}

