/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.util.base.OSType;
import java.util.List;
import org.eclipse.swt.SWT;

public class DebuggerRunToLineHandler
extends DebuggerBaseHandler {
    public DebuggerRunToLineHandler() {
        super("dbgRunToLine", S.s(555), null, "eclipse/runtoline_co.png", 0);
        if (!OSType.determine().isMac()) {
            this.setAccelerator(SWT.MOD1 | 0x52);
        }
    }

    @Override
    public boolean canExecute() {
        return this.canStepOperation() && this.getCodeUnitAddress() != null;
    }

    @Override
    public void execute() {
        this.setTemporaryBp();
        IDebuggerUnit dbg = this.getCurrentDebugger();
        this.executeWithPopup(() -> dbg.run());
    }

    private boolean setTemporaryBp() {
        ICodeUnit unit = (ICodeUnit)this.getActiveUnit();
        String address = DebuggerRunToLineHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE).getAddress();
        IRuntimeProject prj = this.context.getOpenedProject();
        List<IDebuggerUnit> debuggers = RuntimeProjectUtil.findUnitsByType(prj, IDebuggerUnit.class, false);
        for (IDebuggerUnit dbg : debuggers) {
            IDebuggerBreakpoint bp;
            if (!dbg.getPotentialDebuggees().contains(unit) || (bp = dbg.getBreakpoint(address, unit)) == null) continue;
            return false;
        }
        UIState uiState = this.context.getUIState(unit);
        for (IDebuggerUnit dbg : debuggers) {
            if (!dbg.getPotentialDebuggees().contains(unit)) continue;
            dbg.setBreakpoint(address, unit);
            uiState.setTemporaryBreakpoint(address, 1);
            return true;
        }
        if (uiState.isBreakpoint(address)) {
            return false;
        }
        uiState.setTemporaryBreakpoint(address, 1);
        return true;
    }
}

