/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDalvikDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.debugger.DebuggerBaseHandler;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Shell;

public class DebuggerRegisterDebuggee
extends DebuggerBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(DebuggerRegisterDebuggee.class);

    public DebuggerRegisterDebuggee() {
        super("dbgRegisterDebuggee", "Register Addition", "Add a code unit to a debugging session", "eclipse/add_obj.png", 0);
    }

    @Override
    public boolean canExecute() {
        return this.isDebuggerAttached();
    }

    @Override
    public void execute() {
        IDebuggerUnit dbg = this.getCurrentDebugger();
        if (dbg == null) {
            return;
        }
        Class clz = dbg instanceof IDalvikDebuggerUnit ? IDexUnit.class : INativeCodeUnit.class;
        List<IDexUnit> units = RuntimeProjectUtil.findUnitsByType(this.context.getMainProject(), clz, false);
        List<? extends ICodeUnit> currentDebuggees = dbg.getPotentialDebuggees();
        units = units.stream().filter(u -> !currentDebuggees.contains(u)).collect(Collectors.toList());
        UnitSelectionDialog dlg = new UnitSelectionDialog(this.getShell(), "Select additional target", units);
        String msg = Strings.ff("Select an additional code unit to be attached to the debugger: \"%s\" (%s)", dbg.getName(), dbg.getFormatType());
        dlg.setMessage(msg);
        List<Integer> sels = dlg.openMulti();
        if (sels != null && !sels.isEmpty()) {
            for (Integer sel : sels) {
                ICodeUnit unit = units.get(sel);
                boolean success = dbg.registerDebuggee(unit);
                if (success) {
                    logger.info("Successfully attached to debugger: %s", UnitUtil.buildFullyQualifiedUnitPath(unit));
                    continue;
                }
                logger.info("Failed to attach to debugger: %s", UnitUtil.buildFullyQualifiedUnitPath(unit));
            }
        }
    }

    static class UnitSelectionDialog
    extends DataFrameDialog {
        public UnitSelectionDialog(Shell parent, String caption, List<? extends IUnit> units) {
            super(parent, caption, true, "unitSelectionDialog");
            DataFrame df = new DataFrame(S.s(591));
            for (IUnit iUnit : units) {
                df.addRow(UnitUtil.buildFullyQualifiedUnitPath(iUnit));
            }
            this.setDataFrame(df);
            this.setDisplayIndex(true);
        }
    }
}

