/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.debugger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerOperationType;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class DebuggerBaseHandler
extends JebBaseHandler {
    private static final LoadingCache<IDebuggerUnit, DebuggerThreadStatus> threadStatusMap = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(3L, TimeUnit.SECONDS).build(new CacheLoader<IDebuggerUnit, DebuggerThreadStatus>(){

        @Override
        public DebuggerThreadStatus load(IDebuggerUnit dbg) {
            if (dbg.hasDefaultThread() && dbg.canPerformOperation(DebuggerOperationType.UNKNOWN)) {
                IDebuggerThread thread = dbg.getDefaultThread();
                return thread.getStatus();
            }
            return DebuggerThreadStatus.UNKNOWN;
        }
    });
    private static final LoadingCache<IDebuggerUnit, Boolean> unavailableThreads = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(10L, TimeUnit.SECONDS).build(new CacheLoader<IDebuggerUnit, Boolean>(){

        @Override
        public Boolean load(IDebuggerUnit dbg) {
            return Boolean.TRUE;
        }
    });

    public DebuggerBaseHandler(String id, String name, String tooltip, String icon, int accelerator) {
        super(id, name, 0, null, icon, accelerator);
    }

    @Override
    public boolean canExecute() {
        return this.isDebuggerAttached();
    }

    @Override
    public void run() {
        threadStatusMap.invalidateAll();
        unavailableThreads.invalidateAll();
        super.run();
    }

    public IDebuggerUnit getCurrentDebugger() {
        IUnit unit = this.getCurrentUnit();
        return HandlerUtil.getCurrentDebugger(this.context, unit);
    }

    public boolean isDebuggerAttached() {
        IDebuggerUnit dbg = this.getCurrentDebugger();
        return dbg != null && dbg.isAttached();
    }

    public JebAddress getCodeUnitAddress() {
        if (this.getActiveUnit() instanceof ICodeUnit) {
            return DebuggerBaseHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE);
        }
        return null;
    }

    public boolean hasDefaultThread() {
        IDebuggerUnit dbg = this.getCurrentDebugger();
        return dbg != null && dbg.isAttached() && dbg.hasDefaultThread();
    }

    public boolean canStepOperation() {
        return this.canStepOperation(true);
    }

    public boolean canStepOperation(boolean fast) {
        final IDebuggerUnit dbg = this.getCurrentDebugger();
        if (dbg != null && dbg.isAttached()) {
            DebuggerThreadStatus status = (DebuggerThreadStatus)((Object)threadStatusMap.getIfPresent(dbg));
            if (status == null) {
                if (unavailableThreads.getIfPresent(dbg) == Boolean.TRUE) {
                    return false;
                }
                Thread t = new Thread("Dbg Thread Status"){

                    @Override
                    public void run() {
                        try {
                            threadStatusMap.get(dbg);
                        }
                        catch (ExecutionException executionException) {}
                    }
                };
                if (fast) {
                    t.start();
                    try {
                        t.join(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (t.isAlive()) {
                        try {
                            unavailableThreads.get(dbg);
                        }
                        catch (ExecutionException executionException) {}
                    }
                } else {
                    t.run();
                }
                status = (DebuggerThreadStatus)((Object)threadStatusMap.getIfPresent(dbg));
            }
            return status == DebuggerThreadStatus.PAUSED;
        }
        return false;
    }

    public boolean canAttachDebugger() {
        IUnit last;
        IUnitCreator parent;
        IUnit unit = this.getCurrentUnit();
        if (unit == null) {
            return false;
        }
        ArrayList<IUnit> candidates = new ArrayList<IUnit>();
        candidates.add(unit);
        for (int i = 0; i < 3 && (parent = (last = (IUnit)candidates.get(candidates.size() - 1)).getParent()) instanceof IUnit; ++i) {
            candidates.add((IUnit)parent);
        }
        IUnitProcessor processor = unit.getUnitProcessor();
        if (processor == null) {
            return false;
        }
        for (IUnitIdentifier identifier : processor.getUnitIdentifiers()) {
            String ftype = identifier.getFormatType();
            if (ftype == null || !ftype.startsWith("dbug_")) continue;
            for (IUnit candidate : candidates) {
                boolean success = identifier.canIdentify(null, candidate, null, null);
                if (!success) continue;
                return true;
            }
        }
        return false;
    }

    public void restoreUIBreakpoints(IDebuggerUnit dbg) {
        for (ICodeUnit iCodeUnit : dbg.getPotentialDebuggees()) {
            Map<String, Boolean> uiBreakpoints = this.context.getUIState(iCodeUnit).getBreakpoints();
            for (String bpAddress : uiBreakpoints.keySet()) {
                IDebuggerBreakpoint bp = dbg.setBreakpoint(bpAddress, iCodeUnit);
                if (bp == null) continue;
                bp.setEnabled(uiBreakpoints.get(bpAddress));
            }
        }
    }

    protected void executeWithPopup(Runnable r) {
        this.context.executeTaskWithPopupDelay(1000, "Please wait...", false, r);
    }
}

