/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.JvmMethodSig;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexMethodEditorDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.SWT;

public class AndroidMethodEditorHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidMethodEditorHandler.class);

    public AndroidMethodEditorHandler() {
        super("androidDexMethodEditor", "Dex Method Editor", 0, null, "eclipse/edit_method.png", SWT.MOD2 | 0x4E);
    }

    @Override
    public boolean canExecute() {
        return this.getMethodAddress() != null;
    }

    @Override
    public void execute() {
        String msig = this.getMethodAddress();
        if (msig == null) {
            return;
        }
        JvmMethodSig _m = JvmMethodSig.parseSafe(msig);
        if (_m == null || _m.getParameterTypes().size() == 0) {
            return;
        }
        IDexUnit dex = this.checkDex();
        IDexMethod m = dex.getMethod(msig);
        if (m == null) {
            return;
        }
        DexMethodEditorDialog dlg = new DexMethodEditorDialog(this.getShell(), dex, m);
        dlg.open();
    }

    private String getMethodAddress() {
        Object obj;
        if (this.part == null) {
            return null;
        }
        IDexUnit dex = this.checkDex();
        if (dex == null) {
            return null;
        }
        long itemId = AndroidMethodEditorHandler.getActiveItemId(this.part);
        if (itemId != 0L && (obj = dex.getItemObject(itemId)) instanceof IDexMethod) {
            return ((IDexMethod)obj).getSignature();
        }
        String addr = this.getActiveAddress();
        if (addr == null) {
            return null;
        }
        if (!addr.contains("->") || addr.contains(":")) {
            return null;
        }
        int pos = addr.lastIndexOf(43);
        if (pos >= 0) {
            addr = addr.substring(0, pos);
        }
        return addr;
    }
}

