/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.swt.widgets.FileDialog;

public class AndroidMergeAdditionaDexHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidMergeAdditionaDexHandler.class);

    public AndroidMergeAdditionaDexHandler() {
        super("androidMergeAdditionaDex", "Add/Merge additional dex file...", 0, null, "eclipse/add_all.png", 0);
    }

    @Override
    public boolean canExecute() {
        return this.checkDex() != null;
    }

    @Override
    public void execute() {
        IDexUnit dex = this.checkDex();
        if (dex == null) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4098);
        dlg.setText("Select file(s) to merge into the current dex unit (dex or zip/apk containing dex)");
        dlg.setFilterPath(this.context.getDefaultPathForDialog("dlgJebFileOpen"));
        dlg.setFilterExtensions(new String[]{"*.dex", "*.apk", "*.zip", "*.*"});
        String path0 = dlg.open();
        if (path0 == null) {
            return;
        }
        String basedir = dlg.getFilterPath();
        this.context.setDefaultPathForDialog("dlgJebFileOpen", basedir);
        for (String filename : dlg.getFileNames()) {
            File file = new File(basedir, filename);
            String path = file.getAbsolutePath();
            try {
                logger.info("Adding file %s to unit: %s", path, UnitUtil.buildFullyQualifiedUnitPath(dex));
                dex.addDex(new FileInput(path));
            }
            catch (IOException e) {
                logger.catching(e);
                UI.error(e.getMessage());
            }
            catch (Exception e) {
                HashMap<String, Object> extramap = new HashMap<String, Object>();
                extramap.put("dnuart", true);
                extramap.put("pbmfp", path);
                this.context.getErrorHandler().processThrowable(e, true, false, false, null, extramap, null);
            }
        }
    }
}

