/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.DecompilationContext;
import com.pnfsoftware.jeb.core.units.code.DecompilationOptions;
import com.pnfsoftware.jeb.core.units.code.android.DexDecompilerEvent;
import com.pnfsoftware.jeb.core.units.code.android.DexDecompilerEventQueue;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexGlobalAnalysisDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.SelectorHandler;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.base.CallableWithProgressCallback;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AndroidGlobalAnalysisHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidGlobalAnalysisHandler.class);
    private static final int dr = 5;

    public AndroidGlobalAnalysisHandler() {
        super("androidGlobalAnalysis", "Global analysis...", 0, null, null, 0);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null && this.checkDex() != null;
    }

    @Override
    public void execute() {
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        if (!DecompilerHelper.isDexDecompilerAvailable(engctx)) {
            UI.warn("Your JEB build does not ship with the dex decompiler.");
            return;
        }
        int methodTimeout = 60;
        int totalTimeout = 180;
        String filterIncl = "";
        String filterExcl = "";
        if (this.context != null) {
            IPropertyManager pm = this.context.getPropertyManager();
            methodTimeout = pm.getInteger(".ui.android.ga.MethodTimeout", methodTimeout);
            totalTimeout = pm.getInteger(".ui.android.ga.TotalTimeout", totalTimeout);
            filterIncl = pm.getString(".ui.android.ga.InclusionList", filterIncl);
            filterExcl = pm.getString(".ui.android.ga.ExclusionList", filterExcl);
        }
        DexGlobalAnalysisDialog dlg0 = new DexGlobalAnalysisDialog(this.getShell());
        dlg0.setMethodTimeoutSec(methodTimeout);
        dlg0.setTotalTimeoutSec(totalTimeout);
        dlg0.setInclusions(filterIncl);
        dlg0.setExclusions(filterExcl);
        if (!dlg0.open().booleanValue()) {
            return;
        }
        if (this.context != null) {
            IPropertyManager pm = this.context.getPropertyManager();
            pm.setInteger(".ui.android.ga.MethodTimeout", dlg0.getMethodTimeoutSec());
            pm.setInteger(".ui.android.ga.TotalTimeout", dlg0.getTotalTimeoutSec());
            pm.setString(".ui.android.ga.InclusionList", dlg0.getInclusions());
            pm.setString(".ui.android.ga.ExclusionList", dlg0.getExclusions());
        }
        IDexDecompilerUnit dexdec = this.checkDexDecompiler(true, true);
        final DexGlobalAnalysis ga = new DexGlobalAnalysis(dexdec, 10000);
        ga.maxTimePerMethod = dlg0.getMethodTimeoutSec() < 0 ? null : Long.valueOf((long)dlg0.getMethodTimeoutSec() * 1000L);
        ga.maxTimeTotal = dlg0.getTotalTimeoutSec() < 0 ? null : Long.valueOf((long)dlg0.getTotalTimeoutSec() * 1000L);
        ga.filterIncl = dlg0.getInclusions();
        ga.filterExcl = dlg0.getExclusions();
        String caption = "Global analysis...";
        this.context.executeTask(caption, new CallableWithProgressCallback<Boolean>(){

            @Override
            public Boolean call() {
                ga.callback = this.callback;
                return ga.perform();
            }
        });
        final ArrayList<String> addresses = new ArrayList<String>();
        ArrayList<String> details = new ArrayList<String>();
        for (DexDecompilerEvent e : ga.eventQueue.pullAll()) {
            addresses.add(e.getAddress());
            details.add(e.getType() + ": " + e.format(false, false));
        }
        ReferencesDialog dlg = new ReferencesDialog(this.getShell(), "Global analysis results", addresses, details, dexdec, false);
        dlg.setMessage("Hint: This dialog is modeless. Right-click to navigate while keeping the dialog open.\nAll global decompilation events (including those events) are also rendered in the Decompiler/Events fragment.");
        dlg.setSelectorHandler(new SelectorHandler(){

            @Override
            public boolean select(int index) {
                if (index >= 0) {
                    IUnit unit = null;
                    if (AndroidGlobalAnalysisHandler.this.part.getManager() instanceof UnitPartManager) {
                        unit = ((UnitPartManager)AndroidGlobalAnalysisHandler.this.part.getManager()).getUnit();
                    }
                    String address = (String)addresses.get(index);
                    return GraphicalActionExecutor.gotoAddress(AndroidGlobalAnalysisHandler.this.context, unit, address);
                }
                return false;
            }
        });
        int index = dlg.open();
        if (index >= 0) {
            IUnit unit = null;
            if (this.part.getManager() instanceof UnitPartManager) {
                unit = ((UnitPartManager)this.part.getManager()).getUnit();
            }
            String address = (String)addresses.get(index);
            GraphicalActionExecutor.gotoAddress(this.context, unit, address);
        }
    }

    static class DexGlobalAnalysis {
        IDexDecompilerUnit dexdec;
        int eventQueueSize;
        DexDecompilerEventQueue eventQueue;
        IProgressCallback callback;
        Long maxTimePerMethod;
        Long maxTimeTotal;
        String filterIncl;
        String filterExcl;

        DexGlobalAnalysis(IDexDecompilerUnit dexdec) {
            this(dexdec, 10000);
        }

        DexGlobalAnalysis(IDexDecompilerUnit dexdec, int eventQueueSize) {
            this.dexdec = dexdec;
            this.eventQueueSize = eventQueueSize;
        }

        public boolean perform() {
            this.eventQueue = new DexDecompilerEventQueue(this.eventQueueSize);
            this.dexdec.registerEventQueue(this.eventQueue);
            try {
                boolean success;
                long t0 = System.currentTimeMillis();
                DecompilationContext ctx = new DecompilationContext(DecompilationOptions.Builder.newInstance().maxTimePerMethod(this.maxTimePerMethod).maxTimeTotal(this.maxTimeTotal).flags(59).build());
                ctx.setCallback(this.callback);
                boolean isDemo = Licensing.isDemoBuild();
                if (isDemo) {
                    this.filterIncl = null;
                    this.filterExcl = null;
                }
                if (this.filterIncl == null) {
                    this.filterIncl = "";
                }
                if (this.filterExcl == null) {
                    this.filterExcl = "";
                }
                ArrayList<String> incllist = new ArrayList<String>();
                for (String pfx : this.filterIncl.split("[\\s,]")) {
                    if ((pfx = pfx.trim()).isBlank()) continue;
                    incllist.add(pfx);
                }
                ArrayList<String> excllist = new ArrayList<String>();
                for (String bl : this.filterExcl.split("[\\s,]")) {
                    String string = bl.trim();
                    if (string.isBlank()) continue;
                    excllist.add(string);
                }
                if (incllist.isEmpty() && excllist.isEmpty() && !isDemo) {
                    success = this.dexdec.decompileAllMethods(ctx);
                } else {
                    List<String> mlist = new ArrayList<String>();
                    for (IDexMethod iDexMethod : this.dexdec.getCodeUnit().getMethods()) {
                        if (!iDexMethod.isInternal() || iDexMethod.getData().getCodeItem() == null || !incllist.isEmpty() && !this.isMatch(incllist, iDexMethod) || !excllist.isEmpty() && this.isMatch(excllist, iDexMethod)) continue;
                        mlist.add(iDexMethod.getSignature(false));
                    }
                    if (mlist.isEmpty()) {
                        logger.warn("The current filters result in 0 method scheduled for global analysis", new Object[0]);
                    }
                    if (isDemo) {
                        mlist = mlist.stream().filter(x -> x.hashCode() % 5 == 0).collect(Collectors.toList());
                    }
                    success = this.dexdec.decompileMethods(mlist, ctx);
                }
                long exectime = System.currentTimeMillis() - t0;
                logger.debug("dex global analysis: %b - %d methods in %dms", success, ctx.getResultMap().size(), exectime);
                boolean bl = success;
                return bl;
            }
            finally {
                this.dexdec.runGarbageCollection();
                this.dexdec.unregisterEventQueue(this.eventQueue);
            }
        }

        private boolean isMatch(List<String> sigPrefixes, IDexMethod m) {
            String sig = m.getSignature();
            for (String pfx : sigPrefixes) {
                if (!sig.startsWith(pfx)) continue;
                return true;
            }
            return false;
        }
    }
}

