/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.DexDecompilerEvent;
import com.pnfsoftware.jeb.core.units.code.android.DexDecompilerEventQueue;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.IGenericUnpacker;
import com.pnfsoftware.jeb.core.units.code.android.ir.DexDecEvaluationException;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexGenericUnpackingDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.SelectorHandler;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.base.CallableWithProgressCallback;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;

public class AndroidGenericUnpackingHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidGenericUnpackingHandler.class);

    public AndroidGenericUnpackingHandler() {
        super("androidGenericUnpacking", "Generic unpacking...", 0, null, null, 0);
    }

    private boolean isAllowed() {
        return Licensing.isFullBuild() && (Licensing.buildkey.equals("jeb-internal") || Licensing.buildkey.startsWith("jeb-pro"));
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null && this.checkDex() != null;
    }

    @Override
    public void execute() {
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        IDexUnit dex = this.checkDex();
        if (dex == null) {
            return;
        }
        if (!this.isAllowed()) {
            UI.warn("The generic unpacker is requires JEB Pro (not available in the demo or JEB Android)");
            return;
        }
        IUnitCreator parent = dex.getParent();
        if (!(parent instanceof IApkUnit)) {
            UI.info("The generic unpacker requires an APK (only a Dex unit was found).");
            return;
        }
        if (!DecompilerHelper.isDexDecompilerAvailable(engctx)) {
            UI.warn("Your JEB build does not ship with the dex decompiler.");
            return;
        }
        int totalTimeout = 180;
        boolean useUnpackedDex = true;
        boolean useUnpackedLibs = true;
        boolean monitorEvents = true;
        if (this.context != null) {
            IPropertyManager pm = this.context.getPropertyManager();
            totalTimeout = pm.getInteger(".ui.android.gu.TotalTimeout", totalTimeout);
            useUnpackedDex = pm.getBoolean(".ui.android.gu.UseUnpackedDex", useUnpackedDex);
            useUnpackedLibs = pm.getBoolean(".ui.android.gu.UseUnpackedLibs", useUnpackedLibs);
            monitorEvents = pm.getBoolean(".ui.android.gu.MonitorEvents", monitorEvents);
        }
        DexGenericUnpackingDialog dlg0 = new DexGenericUnpackingDialog(this.getShell());
        dlg0.setTotalTimeoutSec(totalTimeout);
        dlg0.setUseUnpackedDex(useUnpackedDex);
        dlg0.setUseUnpackedLibs(useUnpackedLibs);
        dlg0.setMonitorEvents(monitorEvents);
        if (!dlg0.open().booleanValue()) {
            return;
        }
        if (this.context != null) {
            IPropertyManager pm = this.context.getPropertyManager();
            pm.setInteger(".ui.android.gu.TotalTimeout", dlg0.getTotalTimeoutSec());
            pm.setBoolean(".ui.android.gu.UseUnpackedDex", dlg0.getUseUnpackedDex());
            pm.setBoolean(".ui.android.gu.UseUnpackedLibs", dlg0.getUseUnpackedLibs());
            pm.setBoolean(".ui.android.gu.MonitorEvents", dlg0.getMonitorEvents());
        }
        IDexDecompilerUnit dexdec = this.checkDexDecompiler(true, true);
        final DexGenericUnpacking gu = new DexGenericUnpacking(dexdec, 10000);
        gu.maxTimeTotal = dlg0.getTotalTimeoutSec() < 0 ? null : Long.valueOf((long)dlg0.getTotalTimeoutSec() * 1000L);
        gu.useUnpackedDex = dlg0.getUseUnpackedDex();
        gu.useUnpackedLibs = dlg0.getUseUnpackedLibs();
        gu.monitorEvents = dlg0.getMonitorEvents();
        String caption = "Generic unpacking...";
        this.context.executeTask(caption, new CallableWithProgressCallback<Boolean>(){

            @Override
            public Boolean call() {
                gu.callback = this.callback;
                return gu.perform();
            }
        });
        if (gu.report != null) {
            TextDialog v = new TextDialog(this.getShell(), "Unpacking reports (monitor events)", gu.report, "androidGenericUnpackerMonitorReportDlg");
            v.setLineCount(40);
            v.setColumnCount(120);
            v.setNoWordWrap(true);
            v.setEditable(false);
            v.setSelected(false);
            v.setFont(this.context.getFontManager().getCodeFont());
            v.setOkLabelId(201);
            v.setCancelLabelId(null);
            v.open();
        }
        final ArrayList<String> addresses = new ArrayList<String>();
        ArrayList<String> details = new ArrayList<String>();
        for (DexDecompilerEvent e : gu.eventQueue.pullAll()) {
            addresses.add(e.getAddress());
            details.add(e.getType() + ": " + e.format(false, false));
        }
        ReferencesDialog dlg = new ReferencesDialog(this.getShell(), "Generic unpacking results", addresses, details, dexdec, false);
        dlg.setMessage("Hint: This dialog is modeless. Right-click to navigate while keeping the dialog open.");
        dlg.setSelectorHandler(new SelectorHandler(){

            @Override
            public boolean select(int index) {
                if (index >= 0) {
                    IUnit unit = null;
                    if (AndroidGenericUnpackingHandler.this.part.getManager() instanceof UnitPartManager) {
                        unit = ((UnitPartManager)AndroidGenericUnpackingHandler.this.part.getManager()).getUnit();
                    }
                    String address = (String)addresses.get(index);
                    return GraphicalActionExecutor.gotoAddress(AndroidGenericUnpackingHandler.this.context, unit, address);
                }
                return false;
            }
        });
        int index = dlg.open();
        if (index >= 0) {
            IUnit unit = null;
            if (this.part.getManager() instanceof UnitPartManager) {
                unit = ((UnitPartManager)this.part.getManager()).getUnit();
            }
            String address = (String)addresses.get(index);
            GraphicalActionExecutor.gotoAddress(this.context, unit, address);
        }
    }

    static class DexGenericUnpacking {
        IDexDecompilerUnit dexdec;
        int eventQueueSize;
        DexDecompilerEventQueue eventQueue;
        IProgressCallback callback;
        Long maxTimeTotal;
        Boolean useUnpackedDex;
        Boolean useUnpackedLibs;
        Boolean monitorEvents;
        String report;

        DexGenericUnpacking(IDexDecompilerUnit dexdec) {
            this(dexdec, 10000);
        }

        DexGenericUnpacking(IDexDecompilerUnit dexdec, int eventQueueSize) {
            this.dexdec = dexdec;
            this.eventQueueSize = eventQueueSize;
        }

        /*
         * Loose catch block
         */
        public boolean perform() {
            this.eventQueue = new DexDecompilerEventQueue(this.eventQueueSize);
            this.dexdec.registerEventQueue(this.eventQueue);
            try {
                boolean bl;
                IGenericUnpacker unpacker = this.dexdec.createGenericUnpacker();
                if (this.maxTimeTotal != null) {
                    unpacker.setMaxExecutionTime(this.maxTimeTotal);
                }
                if (this.useUnpackedDex != null) {
                    unpacker.setIntegrateRecoveredDexFiles(this.useUnpackedDex);
                }
                if (this.useUnpackedLibs != null) {
                    unpacker.setUseRecoveredSoFiles(this.useUnpackedLibs);
                }
                if (this.monitorEvents != null) {
                    unpacker.setMonitorEvents(this.monitorEvents);
                }
                long t0 = System.currentTimeMillis();
                try {
                    unpacker.attemptUnpack();
                    bl = true;
                    if (this.monitorEvents != null && this.monitorEvents.booleanValue()) {
                        this.report = unpacker.formatMonitorReport(0);
                    }
                    unpacker.teardown();
                }
                catch (DexDecEvaluationException dexDecEvaluationException) {
                    boolean bl2 = true;
                    if (this.monitorEvents != null && this.monitorEvents.booleanValue()) {
                        this.report = unpacker.formatMonitorReport(0);
                    }
                    unpacker.teardown();
                    long exectime = System.currentTimeMillis() - t0;
                    (new Object[1])[0] = TimeFormatter.formatTimestampDelta(exectime);
                    this.dexdec.runGarbageCollection();
                    this.dexdec.unregisterEventQueue(this.eventQueue);
                    return bl2;
                }
                catch (Exception e) {
                    logger.catching(e);
                    boolean bl3 = false;
                    if (this.monitorEvents != null && this.monitorEvents.booleanValue()) {
                        this.report = unpacker.formatMonitorReport(0);
                    }
                    unpacker.teardown();
                    long exectime = System.currentTimeMillis() - t0;
                    (new Object[1])[0] = TimeFormatter.formatTimestampDelta(exectime);
                    this.dexdec.runGarbageCollection();
                    this.dexdec.unregisterEventQueue(this.eventQueue);
                    return bl3;
                    {
                        catch (Throwable throwable) {
                            if (this.monitorEvents != null && this.monitorEvents.booleanValue()) {
                                this.report = unpacker.formatMonitorReport(0);
                            }
                            unpacker.teardown();
                            long exectime2 = System.currentTimeMillis() - t0;
                            (new Object[1])[0] = TimeFormatter.formatTimestampDelta(exectime2);
                            throw throwable;
                            {
                                catch (Throwable throwable2) {
                                    throw throwable2;
                                }
                            }
                        }
                    }
                }
                long exectime = System.currentTimeMillis() - t0;
                (new Object[1])[0] = TimeFormatter.formatTimestampDelta(exectime);
                return bl;
            }
            finally {
                this.dexdec.runGarbageCollection();
                this.dexdec.unregisterEventQueue(this.eventQueue);
            }
        }
    }
}

