/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.dao.IFileStore;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;

public class AndroidEmuSettingsHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidEmuSettingsHandler.class);

    public AndroidEmuSettingsHandler() {
        super("androidEmuSettings", "Emulator settings...", 0, null, null, 0);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null;
    }

    @Override
    public void execute() {
        String text;
        IFileStore pluginStore;
        String path;
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        if (!DecompilerHelper.isDexDecompilerAvailable(engctx)) {
            UI.warn("Your JEB build does not ship with the dex decompiler.");
            return;
        }
        IDexDecompilerUnit dexdec = this.checkDexDecompiler(true, false);
        String pname = "EmulatorConfigPath";
        if (dexdec != null) {
            path = dexdec.getPropertyManager().getString(pname);
        } else {
            pname = UnitUtil.decompilerProperty(engctx, "dex", pname);
            path = engctx.getPropertyManager().getString(pname);
        }
        if (Strings.isBlank(path)) {
            return;
        }
        File f = new File(path);
        if (!f.isAbsolute() && (pluginStore = engctx.getDataProvider().getPluginStore()) != null) {
            File pluginsLocation = new File(pluginStore.getStoreLocation());
            f = new File(pluginsLocation, path);
        }
        try {
            if (f.isFile()) {
                text = Strings.decodeLocal(IO.readFile(f));
            } else {
                File ft = new File(f.getAbsolutePath() + ".TEMPLATE");
                if (!ft.isFile()) {
                    logger.error("Could not find the template file: %s", ft.getAbsolutePath());
                    return;
                }
                logger.info("Using template file: %s", ft.getAbsolutePath());
                text = Strings.decodeLocal(IO.readFile(ft));
                StringBuilder sb = new StringBuilder(text.length());
                for (String line : Strings.splitLines(text)) {
                    if (line.startsWith("#*TEMPLATE*")) continue;
                    sb.append(line).append(Strings.LINESEP);
                }
                text = sb.toString();
            }
        }
        catch (IOException e) {
            logger.catching(e);
            return;
        }
        String label = "Emulator options for the Android DEX decompiler";
        TextDialog dlg = new TextDialog(this.getShell(), "Emulator settings", text, "dlgDexdecEmuOpt");
        dlg.setNoWordWrap(true);
        dlg.setTextLabel(label);
        dlg.setFont(this.context.getFontManager().getCodeFont());
        dlg.setColumnCount(100);
        dlg.setLineCount(40);
        dlg.setEditable(true);
        text = dlg.open();
        if (text == null) {
            return;
        }
        try {
            IO.writeFile(f, text);
        }
        catch (IOException e) {
            logger.catching(e);
        }
    }
}

