/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.android;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.android.AndroidBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class AndroidContextInformationDatabaseHandler
extends AndroidBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(AndroidContextInformationDatabaseHandler.class);

    public AndroidContextInformationDatabaseHandler() {
        super("androidContextInfoDatabase", "Context information database...", 0, null, null, 0);
    }

    @Override
    public boolean canExecute() {
        return this.context.getEnginesContext() != null;
    }

    @Override
    public void execute() {
        Object label;
        String info;
        IEnginesContext engctx = this.context.getEnginesContext();
        if (engctx == null) {
            return;
        }
        IUnit unit = this.getCurrentUnit();
        IDexUnit dex = null;
        if (unit instanceof IDexUnit) {
            dex = (IDexUnit)unit;
        }
        String pname = "ContextInfoDb";
        if (dex != null) {
            info = dex.getPropertyManager().getString(pname);
            label = "Current project properties (mods will not affect your globals settings)";
        } else {
            pname = UnitUtil.unitProperty(engctx, "dex", pname);
            info = engctx.getPropertyManager().getString(pname);
            label = "Global settings";
            if (this.context.getOpenedProject() != null) {
                label = (String)label + " (your current project will not be affected!)";
            }
        }
        TextDialog dlg = new TextDialog(this.getShell(), "Context information database", info, "dexCIDB");
        dlg.setNoWordWrap(true);
        dlg.setTextLabel((String)label);
        dlg.setFont(this.context.getFontManager().getCodeFont());
        dlg.setColumnCount(100);
        dlg.setLineCount(40);
        dlg.setEditable(true);
        info = dlg.open();
        if (info == null) {
            return;
        }
        boolean success = dex != null ? dex.getPropertyManager().setString(pname, info) : engctx.getPropertyManager().setString(pname, info);
        if (!success) {
            logger.warn("Failed to update the context information database", new Object[0]);
        }
    }
}

