/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IMetadataGroup;
import com.pnfsoftware.jeb.core.units.IMetadataManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.MetadataGroup;
import com.pnfsoftware.jeb.core.units.MetadataGroupType;
import com.pnfsoftware.jeb.core.units.UnitChangeEventData;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.SWT;

public class ActionToggleHighlightHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionToggleHighlightHandler.class);

    public ActionToggleHighlightHandler() {
        super("toggleHighlight", "Toggle Highlight", null, "images/highlight.png");
        this.setAccelerator(SWT.MOD1 | 0x4D);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        IUnit unit = this.getActiveUnit();
        if (!(unit instanceof IInteractiveUnit)) {
            return true;
        }
        JebAddress address = ActionToggleHighlightHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE);
        return address != null;
    }

    @Override
    public void execute() {
        if (!(this.getActiveUnit() instanceof IInteractiveUnit)) {
            return;
        }
        IInteractiveUnit unit = (IInteractiveUnit)this.getActiveUnit();
        String address = this.getActiveAddress();
        if (address == null) {
            return;
        }
        IMetadataManager mm = unit.getMetadataManager();
        if (mm == null) {
            return;
        }
        IMetadataGroup grp = mm.getGroupByName("HIGHLIGHTS_MANUAL");
        if (grp == null && !mm.addGroup(grp = new MetadataGroup("HIGHLIGHTS_MANUAL", MetadataGroupType.CLASSID))) {
            return;
        }
        if (grp.getData(address) != null) {
            grp.setData(address, null);
        } else {
            grp.setData(address, (Object)ItemClassIdentifiers.INFO_NORMAL);
        }
        unit.notifyListeners(new JebEvent(J.UnitChange, new UnitChangeEventData(9, unit)));
    }
}

