/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.core.BookmarkManager;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Calendar;
import org.eclipse.swt.SWT;

public class ActionToggleBookmarkHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionToggleBookmarkHandler.class);

    public ActionToggleBookmarkHandler() {
        super("toggleFavorite", "Toggle Favorite", null, "eclipse/star.png");
        this.setAccelerator(SWT.MOD1 | 0x1000015);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        IUnit unit = this.getActiveUnit();
        if (!(unit instanceof IAddressableUnit)) {
            return true;
        }
        JebAddress address = ActionToggleBookmarkHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE);
        return address != null;
    }

    @Override
    public void execute() {
        IRuntimeProject prj = this.context.getOpenedProject();
        IUnit unit = this.getActiveUnit();
        String address = this.getActiveAddress();
        BookmarkManager bm = prj.getBookmarkManager();
        String description = bm.get(unit, address);
        if (description == null) {
            Calendar cal = Calendar.getInstance();
            description = Strings.ff("Bookmarked on %04d-%02d-%02d %02d:%02d:%02d %s", cal.get(1), 1 + cal.get(2), cal.get(5), cal.get(11), 1 + cal.get(12), cal.get(13), cal.getTimeZone().getDisplayName(false, 0));
            String msg = Strings.ff("Unit: %s\nAddress: %s\nDescription:", unit.getName(), address);
            description = UI.ask(this.getShell(), "Bookmark a Favorite", msg, description);
            if (description == null || description.isEmpty()) {
                return;
            }
            bm.set(unit, address, description);
        } else {
            String msg = Strings.ff("Unit: %s\nAddress: %s\nDescription (clear to remove):", unit.getName(), address);
            description = UI.ask(this.getShell(), "Bookmark a Favorite", msg, description);
            if (description == null) {
                return;
            }
            if (description.isEmpty()) {
                bm.remove(unit, address);
            } else {
                bm.set(unit, address, description);
            }
        }
    }
}

