/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.JvmFieldSig;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.core.units.code.java.IJavaConstant;
import com.pnfsoftware.jeb.core.units.code.java.IJavaElement;
import com.pnfsoftware.jeb.core.units.code.java.IJavaExpression;
import com.pnfsoftware.jeb.core.units.code.java.IJavaField;
import com.pnfsoftware.jeb.core.units.code.java.IJavaGlobalContext;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperation;
import com.pnfsoftware.jeb.core.units.code.java.IJavaSourceUnit;
import com.pnfsoftware.jeb.core.units.code.java.IJavaStaticField;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexConstantSelectorDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionGenericHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import java.util.List;
import org.eclipse.swt.SWT;

public class ActionReplaceHandler
extends JebBaseHandler {
    public static final String iconPath = "eclipse/correction_cast.png";

    public ActionReplaceHandler() {
        super("replace", "Replace...", 0, "", iconPath, SWT.MOD1 | 0x4E);
    }

    @Override
    public boolean canExecute() {
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        return this.getActiveUnit() instanceof IInteractiveUnit && ActionReplaceHandler.getActiveItem(this.part) != null;
    }

    @Override
    public void execute() {
        IUnit unit;
        GraphicalActionExecutor executor;
        ActionUIContext uictx = ActionGenericHandler.prepare(this.part, 6);
        if (uictx != null && (executor = new GraphicalActionExecutor(this.getShell(), this.context)).execute(uictx)) {
            return;
        }
        IItem item = JebBaseHandler.getActiveItem(this.part);
        if (item instanceof IActionableItem && (unit = JebBaseHandler.getActiveUnit(this.part)) instanceof IJavaSourceUnit) {
            List<Object> objects;
            IJavaSourceUnit src = (IJavaSourceUnit)unit;
            UnitPartManager pman = (UnitPartManager)this.part.getManager();
            IUnitFragment f = pman.getActiveFragment();
            if (f instanceof AbstractTextFragment && (objects = ((AbstractTextFragment)f).getViewer().getDocumentObjectsAtCaret()).size() >= 2) {
                IJavaConstant _cst = null;
                IJavaConstant _cst0 = null;
                IJavaElement _parent = (IJavaElement)objects.get(objects.size() - 2);
                IJavaElement _elt = (IJavaElement)objects.get(objects.size() - 1);
                Object o = objects.get(objects.size() - 1);
                if (o instanceof IJavaConstant) {
                    _cst = (IJavaConstant)o;
                } else if (o instanceof IJavaStaticField) {
                    if ((o = ((IJavaStaticField)o).getTags().get("REPLACED_CONSTANT")) instanceof IJavaConstant) {
                        _cst0 = (IJavaConstant)o;
                    } else if (o == null && objects.size() >= 3 && (o = objects.get(objects.size() - 2)) instanceof IJavaOperation && (o = ((IJavaOperation)o).getTags().get("REPLACED_CONSTANT")) instanceof IJavaConstant) {
                        _cst0 = (IJavaConstant)o;
                        _parent = (IJavaElement)objects.get(objects.size() - 3);
                        _elt = (IJavaElement)objects.get(objects.size() - 2);
                    }
                    _cst = _cst0;
                }
                if (_cst != null) {
                    Comparable<Byte> value = null;
                    IJavaType _csttype = _cst.getType();
                    if (_csttype.isByte()) {
                        value = _cst.getByte();
                    } else if (_csttype.isChar()) {
                        value = Character.valueOf(_cst.getChar());
                    } else if (_csttype.isShort()) {
                        value = _cst.getShort();
                    } else if (_csttype.isInt()) {
                        value = _cst.getInt();
                    } else if (_csttype.isLong()) {
                        value = _cst.getLong();
                    } else if (_csttype.isFloat()) {
                        value = Float.valueOf(_cst.getFloat());
                    } else if (_csttype.isDouble()) {
                        value = _cst.getDouble();
                    }
                    if (value != null) {
                        IDexDecompilerUnit decomp = src.getDecompiler();
                        IDexUnit dex = decomp.getCodeUnit();
                        DexConstantSelectorDialog dlg = new DexConstantSelectorDialog(this.getShell(), dex, value);
                        int idx = dlg.open();
                        if (dlg.isResetRequested()) {
                            if (_cst0 != null && _parent != null && _elt != null && _parent.replaceSubElement(_elt, _cst0)) {
                                src.notifyGenericChange();
                            }
                            return;
                        }
                        if (idx < 0) {
                            return;
                        }
                        DexConstantSelectorDialog.Entry e = dlg.getSelectedEntry();
                        IDexField field = dex.getField(e.fieldIndex);
                        if (field != null) {
                            String fsig = field.getSignature(false);
                            IJavaGlobalContext jctx = decomp.getHighLevelContext();
                            IJavaField _f = jctx.createFieldReference(fsig, true);
                            IJavaType _t = jctx.getTypeFactory().createType(JvmFieldSig.parse((String)fsig).csig);
                            IJavaExpression _repl = jctx.createStaticField(_t, _f);
                            if (this.genCast(field.getFieldTypeSignature(false), _csttype.getSignature())) {
                                _repl = jctx.createCastOperation(_csttype, _repl);
                            }
                            if (_parent != null && _elt != null && _parent.replaceSubElement(_elt, _repl)) {
                                _repl.addTag("REPLACED_CONSTANT", _cst);
                                src.notifyGenericChange();
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean genCast(String fieldsig, String cstsig) {
        switch (cstsig) {
            case "B": {
                switch (fieldsig) {
                    case "B": {
                        return false;
                    }
                }
                return true;
            }
            case "C": {
                switch (fieldsig) {
                    case "C": {
                        return false;
                    }
                }
                return true;
            }
            case "S": {
                switch (fieldsig) {
                    case "B": 
                    case "S": {
                        return false;
                    }
                }
                return true;
            }
            case "I": {
                switch (fieldsig) {
                    case "B": 
                    case "C": 
                    case "S": 
                    case "I": {
                        return false;
                    }
                }
                return true;
            }
            case "J": {
                switch (fieldsig) {
                    case "B": 
                    case "C": 
                    case "S": 
                    case "I": 
                    case "J": {
                        return false;
                    }
                }
                return true;
            }
            case "F": {
                switch (fieldsig) {
                    case "F": {
                        return false;
                    }
                }
                return true;
            }
            case "D": {
                switch (fieldsig) {
                    case "F": 
                    case "D": {
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }
}

