/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public abstract class ActionGenericHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionGenericHandler.class);
    protected int actionId;

    public ActionGenericHandler(int actionId, String id, String name, String tooltip, String icon, int accelerator) {
        super(id, name, 0, tooltip, icon, accelerator);
        this.actionId = actionId;
    }

    @Override
    public boolean canExecute() {
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        try {
            return ActionGenericHandler.prepare(this.part, this.actionId) != null;
        }
        catch (Exception e) {
            logger.catching(e);
            throw e;
        }
    }

    @Override
    public final void execute() {
        ActionUIContext uictx = ActionGenericHandler.prepare(this.part, this.actionId);
        if (uictx != null) {
            GraphicalActionExecutor executor = new GraphicalActionExecutor(this.getShell(), this.context);
            executor.execute(uictx);
        }
    }

    public static ActionUIContext prepare(IMPart part, int actionId) {
        JebAddress address;
        IItem item;
        long itemId;
        ActionContext info;
        IInteractiveUnit unit;
        IUnit unit0;
        if (part != null && (unit0 = ActionGenericHandler.getActiveUnit(part)) instanceof IInteractiveUnit && unit0.isProcessed() && (unit = (IInteractiveUnit)unit0).canExecuteAction(info = new ActionContext(unit, actionId, itemId = (item = ActionGenericHandler.getActiveItem(part)) != null && item instanceof IActionableItem ? ((IActionableItem)((Object)item)).getItemId() : 0L, (address = ActionGenericHandler.getActiveAddress(part, AddressConversionPrecision.COARSE)) == null ? null : address.getAddress(), address == null ? null : address.getPrecision()))) {
            AbstractUnitFragment<?> fragment = ActionGenericHandler.getActiveFragment(part);
            return new ActionUIContext(info, fragment);
        }
        return null;
    }
}

